/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.inventory.IWearableContainer;
import com.darkona.adventurebackpack.inventory.InventorySteamJetpack;
import com.darkona.adventurebackpack.inventory.SlotFluid;
import com.darkona.adventurebackpack.inventory.SlotFuel;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerJetpack
extends Container
implements IWearableContainer {
    InventorySteamJetpack inventory;
    EntityPlayer player;
    private final int PLAYER_HOT_START = 0;
    private final int PLAYER_HOT_END = 8;
    private final int PLAYER_INV_START = 9;
    private final int PLAYER_INV_END = 35;
    boolean wearing;

    public ContainerJetpack(EntityPlayer player, InventorySteamJetpack inventory, boolean wearing) {
        this.player = player;
        this.inventory = inventory;
        this.makeSlots(player.field_71071_by);
        this.inventory.func_70295_k_();
        this.wearing = wearing;
    }

    private void bindPlayerInventory(InventoryPlayer invPlayer) {
        int startX = 8;
        int startY = 84;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, startX + 18 * x, 142));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)invPlayer, x + y * 9 + 9, startX + 18 * x, startY + y * 18));
            }
        }
    }

    private void makeSlots(InventoryPlayer invPlayer) {
        this.bindPlayerInventory(invPlayer);
        this.func_75146_a(new SlotFluid(this.inventory, 0, 30, 22));
        this.func_75146_a(new SlotFluid(this.inventory, 1, 30, 52));
        this.func_75146_a(new SlotFuel(this.inventory, 2, 77, 64));
    }

    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        return true;
    }

    public void func_75142_b() {
        if (this.wearing) {
            this.refresh();
            super.func_75142_b();
            if (this.wearing && this.player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)this.player).func_71110_a((Container)this, this.field_75153_a);
                BackpackProperty.syncToNear(this.player);
            }
        } else {
            super.func_75142_b();
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.wearing) {
            this.field_75149_d.remove(player);
        }
        if (!player.field_70170_p.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                ItemStack itemstack = this.inventory.func_70304_b(i);
                if (itemstack == null) continue;
                this.inventory.func_70299_a(i, null);
                player.func_71019_a(itemstack, false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemStack func_82846_b(EntityPlayer player, int i) {
        this.refresh();
        Slot slot = this.func_75139_a(i);
        ItemStack result = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            if (i >= 36 && !this.func_75135_a(stack, 0, 36, false)) {
                return null;
            }
            if (i < 36) {
                if (SlotFluid.valid(stack)) {
                    int JETPACK_INV_START = 36;
                    if (this.func_75135_a(stack, JETPACK_INV_START, JETPACK_INV_START + 1, false)) {
                        // empty if block
                    }
                } else {
                    int JETPACK_FUEL_START = 38;
                    if (this.inventory.isFuel(stack) && !this.func_75135_a(stack, JETPACK_FUEL_START, JETPACK_FUEL_START + 1, false)) {
                        return null;
                    }
                }
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stack.field_77994_a == result.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stack);
        }
        return result;
    }

    @Override
    public void refresh() {
        this.inventory.func_70295_k_();
    }
}

