/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.recipes.modules;

import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.recipes.RecipesModule;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeCasting;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.lib.MetalRates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Mariculture
extends RecipesModule {
    public Mariculture() {
        super(CompatType.MARICULTURE, "gold", "iron", "copper", "aluminium", "aluminum", "rutile", "titanium", "magnesium");
    }

    @Override
    public void initOre(Ore ore) {
    }

    @Override
    protected void postInit() {
        for (Ore ore : Ore.ores) {
            if (!this.isOreEnabled(ore)) continue;
            this.addRecipesFor(ore);
        }
    }

    private void addRecipesFor(Ore ore) {
        Fluid fluid = this.getFluid(ore);
        MaricultureHandlers.crucible.addRecipe(new RecipeSmelter(Mariculture.getOreStack("ingot", ore), 500 + (int)ore.energy(600.0), new FluidStack(fluid, MetalRates.INGOT), null, 0));
        MaricultureHandlers.crucible.addRecipe(new RecipeSmelter(Mariculture.getOreStack("nugget", ore), 500 + (int)ore.energy(600.0), new FluidStack(fluid, MetalRates.NUGGET), null, 0));
        MaricultureHandlers.crucible.addRecipe(new RecipeSmelter(Mariculture.getOreStack("block", ore), 500 + (int)ore.energy(600.0), new FluidStack(fluid, MetalRates.INGOT * 9), null, 0));
        MaricultureHandlers.crucible.addRecipe(new RecipeSmelter(Mariculture.getOreStack("ore", ore), 500 + (int)ore.energy(600.0), new FluidStack(fluid, MetalRates.ORE), Mariculture.getOreStackExtra("dust", ore), 2));
        MaricultureHandlers.casting.addRecipe((RecipeCasting)new RecipeCasting.RecipeBlockCasting(new FluidStack(fluid, MetalRates.INGOT * 9), Mariculture.getOreStack("block", ore)));
        MaricultureHandlers.casting.addRecipe((RecipeCasting)new RecipeCasting.RecipeIngotCasting(new FluidStack(fluid, MetalRates.INGOT), Mariculture.getOreStack("ingot", ore)));
        MaricultureHandlers.casting.addRecipe((RecipeCasting)new RecipeCasting.RecipeNuggetCasting(new FluidStack(fluid, MetalRates.NUGGET), Mariculture.getOreStack("nugget", ore)));
    }
}

