/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.agriculture;

import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class CropPlantAgriCulture
extends CropPlant {
    private final Block plant;
    private ItemStack fruit;

    public CropPlantAgriCulture(Block plant, ItemStack fruit) {
        this.plant = plant;
        this.fruit = fruit;
    }

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack(this.plant, 1, 0);
    }

    @Override
    public Block getBlock() {
        return this.plant;
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        fruits.add(this.fruit.func_77946_l());
        return fruits;
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        return this.fruit.func_77946_l();
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        for (int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0); amount > 0; --amount) {
            fruits.add(this.fruit.func_77946_l());
        }
        return fruits;
    }

    @Override
    public boolean canBonemeal() {
        return true;
    }

    @Override
    protected IGrowthRequirement initGrowthRequirement() {
        return GrowthRequirementHandler.getNewBuilder().build();
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage, ICrop crop) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon(int growthStage) {
        return this.plant.func_149691_a(0, Math.max(0, growthStage - 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsFlower() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInformation() {
        return "agricraft_journal.agriculture_" + this.getSimpleName();
    }

    @SideOnly(value=Side.CLIENT)
    private String getSimpleName() {
        String name = Block.field_149771_c.func_148750_c((Object)this.plant);
        int index = name.indexOf(58);
        if (index > 0) {
            name = name.substring(index + 1);
        }
        return name;
    }
}

