/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.minetweaker;

import com.InfinityRaider.AgriCraft.api.v1.IMutation;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationHandler;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.agricraft.SeedMutation")
public class SeedMutation {
    @ZenMethod
    public static void add(IItemStack result, IItemStack parent1, IItemStack parent2) {
        ItemStack resultToAdd = MineTweakerMC.getItemStack((IItemStack)result);
        ItemStack parent1ToAdd = MineTweakerMC.getItemStack((IItemStack)parent1);
        ItemStack parent2ToAdd = MineTweakerMC.getItemStack((IItemStack)parent2);
        if (CropPlantHandler.isValidSeed(resultToAdd) && CropPlantHandler.isValidSeed(parent1ToAdd) && CropPlantHandler.isValidSeed(parent2ToAdd)) {
            MineTweakerAPI.apply((IUndoableAction)new AddAction(resultToAdd, parent1ToAdd, parent2ToAdd));
        } else {
            MineTweakerAPI.logError((String)("Adding mutation with result '" + resultToAdd.func_82833_r() + "' failed. All 3 have to be of type ItemSeeds."));
        }
    }

    @ZenMethod
    public static void remove(IItemStack result) {
        ItemStack resultToRemove = MineTweakerMC.getItemStack((IItemStack)result);
        if (CropPlantHandler.isValidSeed(resultToRemove)) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveAction(resultToRemove));
        } else {
            MineTweakerAPI.logError((String)(resultToRemove.func_82833_r() + " is not of type ItemSeeds."));
        }
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final ItemStack result;
        private List<IMutation> removedMutations = new ArrayList<IMutation>();

        public RemoveAction(ItemStack result) {
            this.result = result;
        }

        public void apply() {
            this.removedMutations = MutationHandler.getInstance().removeMutationsByResult(this.result);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            MutationHandler.getInstance().addAll(this.removedMutations);
        }

        public String describe() {
            return "Removing all mutations where '" + this.result.func_82833_r() + "' is the result.";
        }

        public String describeUndo() {
            return "Adding back in all mutations where '" + this.result.func_82833_r() + "' is the result.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddAction
    implements IUndoableAction {
        private final Mutation mutation;

        public AddAction(ItemStack resultToAdd, ItemStack parent1ToAdd, ItemStack parent2ToAdd) {
            this.mutation = new Mutation(resultToAdd, parent1ToAdd, parent2ToAdd);
        }

        public void apply() {
            MutationHandler.getInstance().add(this.mutation);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            MutationHandler.getInstance().remove(this.mutation);
        }

        public String describe() {
            return "Adding mutation '" + this.getEquationString() + "'";
        }

        public String describeUndo() {
            return "Removing previously added mutation '" + this.getEquationString() + "'";
        }

        public Object getOverrideKey() {
            return null;
        }

        private String getEquationString() {
            ItemStack result = this.mutation.getResult();
            ItemStack[] parents = this.mutation.getParents();
            return result.func_82833_r() + " = " + parents[0].func_82833_r() + " + " + parents[1].func_82833_r();
        }
    }
}

