/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.blocks;

import com.InfinityRaider.AgriCraft.blocks.BlockPeripheral;
import com.InfinityRaider.AgriCraft.init.Blocks;
import com.InfinityRaider.AgriCraft.renderers.blocks.RenderBlockBase;
import com.InfinityRaider.AgriCraft.renderers.models.ModelPeripheralProbe;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.TileEntityPeripheral;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderPeripheral
extends RenderBlockBase {
    private static final ResourceLocation probeTexture = new ResourceLocation("AgriCraft".toLowerCase() + ":textures/blocks/peripheralProbe.png");
    private static final ModelBase probeModel = new ModelPeripheralProbe();

    public RenderPeripheral() {
        super(Blocks.blockPeripheral, new TileEntityPeripheral(), true);
    }

    @Override
    protected boolean doWorldRender(Tessellator tessellator, IBlockAccess world, double x, double y, double z, TileEntity tile, Block block, float f, int modelId, RenderBlocks renderer, boolean callFromTESR) {
        if (callFromTESR) {
            if (tile instanceof TileEntityPeripheral) {
                TileEntityPeripheral peripheral = (TileEntityPeripheral)tile;
                this.drawSeed(tessellator, peripheral);
                this.performAnimations(tessellator, peripheral, block.func_149691_a(3, 0), block.func_149720_d(world, (int)x, (int)y, (int)z));
            }
        } else {
            this.renderBase(tessellator, (BlockPeripheral)block, block.func_149720_d(world, (int)x, (int)y, (int)z));
        }
        return true;
    }

    private void drawSeed(Tessellator tessellator, TileEntityPeripheral peripheral) {
        ItemStack stack = peripheral.func_70301_a(36);
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        IIcon icon = stack.func_77973_b().func_77617_a(stack.func_77960_j());
        if (icon == null) {
            return;
        }
        float dx = 0.25f;
        float dy = 0.875f;
        float dz = 0.25f;
        float scale = 0.5f;
        float angle = 90.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94209_e(), (float)icon.func_94206_g(), (float)icon.func_94212_f(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glRotatef((float)(-angle), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
        GL11.glPopMatrix();
    }

    private void performAnimations(Tessellator tessellator, TileEntityPeripheral peripheral, IIcon icon, int cm) {
        int maxDoorPos = 30;
        float unit = 0.0625f;
        GL11.glPushMatrix();
        for (ForgeDirection dir : TileEntityPeripheral.VALID_DIRECTIONS) {
            int timer = peripheral.getTimer(dir);
            float doorPosition = (float)(timer >= maxDoorPos ? maxDoorPos : timer) * 4.0f / (float)maxDoorPos;
            if (doorPosition < 4.0f) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                tessellator.func_78382_b();
                this.drawScaledPrism(tessellator, 4.0f, 2.0f, 0.0f, 8.0f - doorPosition, 14.0f, 1.0f, icon, cm);
                this.drawScaledPrism(tessellator, 8.0f + doorPosition, 2.0f, 0.0f, 12.0f, 14.0f, 1.0f, icon, cm);
                tessellator.func_78381_a();
            }
            float probePosition = (timer < maxDoorPos ? 0 : timer - maxDoorPos) * 90 / maxDoorPos;
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float dx = -0.5f;
            float dy = -1.5f;
            float dz = 9.0f * unit;
            GL11.glTranslatef((float)dx, (float)dy, (float)dz);
            float dX = 0.0f;
            float dY = 21.5f * unit;
            float dZ = -5.5f * unit;
            GL11.glTranslatef((float)dX, (float)dY, (float)dZ);
            GL11.glRotatef((float)probePosition, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-dX), (float)(-dY), (float)(-dZ));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(probeTexture);
            probeModel.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GL11.glTranslatef((float)dX, (float)dY, (float)dZ);
            GL11.glRotatef((float)(-probePosition), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-dX), (float)(-dY), (float)(-dZ));
            GL11.glTranslatef((float)(-dx), (float)(-dy), (float)(-dz));
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        GL11.glPopMatrix();
    }

    private void renderBase(Tessellator tessellator2, BlockPeripheral blockPeripheral, int colorMultiplier) {
        IIcon iconTop = blockPeripheral.func_149691_a(0, 0);
        IIcon iconSide = blockPeripheral.func_149691_a(1, 0);
        IIcon iconBottom = blockPeripheral.func_149691_a(2, 0);
        IIcon iconInside = blockPeripheral.func_149691_a(3, 0);
        float unit = 0.0625f;
        this.drawScaledFaceFrontXZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconTop, 1.0f, colorMultiplier);
        this.drawScaledFaceBackXZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconTop, 1.0f, colorMultiplier);
        this.drawScaledFaceFrontXZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconBottom, 0.0f, colorMultiplier);
        this.drawScaledFaceBackXZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconBottom, 0.0f, colorMultiplier);
        this.drawScaledFaceFrontXY(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconSide, 0.0f, colorMultiplier);
        this.drawScaledFaceBackXY(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconSide, 0.0f, colorMultiplier);
        this.drawScaledFaceFrontYZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconSide, 1.0f, colorMultiplier);
        this.drawScaledFaceBackYZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconSide, 1.0f, colorMultiplier);
        this.drawScaledFaceFrontYZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconSide, 0.0f, colorMultiplier);
        this.drawScaledFaceBackYZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconSide, 0.0f, colorMultiplier);
        this.drawScaledFaceFrontXY(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconSide, 1.0f, colorMultiplier);
        this.drawScaledFaceBackXY(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconSide, 1.0f, colorMultiplier);
        this.drawScaledFaceFrontXZ(tessellator2, 4.0f, 4.0f, 12.0f, 12.0f, iconBottom, 12.0f * unit, colorMultiplier);
        this.drawScaledFaceFrontXY(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconInside, 4.0f * unit, colorMultiplier);
        this.drawScaledFaceBackXY(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconInside, 4.0f * unit, colorMultiplier);
        this.drawScaledFaceFrontYZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconInside, 12.0f * unit, colorMultiplier);
        this.drawScaledFaceBackYZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconInside, 12.0f * unit, colorMultiplier);
        this.drawScaledFaceFrontYZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconInside, 4.0f * unit, colorMultiplier);
        this.drawScaledFaceBackYZ(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconInside, 4.0f * unit, colorMultiplier);
        this.drawScaledFaceFrontXY(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconInside, 12.0f * unit, colorMultiplier);
        this.drawScaledFaceBackXY(tessellator2, 0.0f, 0.0f, 16.0f, 16.0f, iconInside, 12.0f * unit, colorMultiplier);
    }

    @Override
    protected void doInventoryRender(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        tessellator.func_78382_b();
        this.renderBase(tessellator, (BlockPeripheral)Blocks.blockPeripheral, 0xFFFFFF);
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    @Override
    public boolean shouldBehaveAsTESR() {
        return true;
    }

    @Override
    public boolean shouldBehaveAsISBRH() {
        return true;
    }
}

