/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.api.v1.IFertiliser;
import com.InfinityRaider.AgriCraft.api.v2.IAdditionalCropData;
import com.InfinityRaider.AgriCraft.api.v2.ISeedStats;
import com.InfinityRaider.AgriCraft.api.v2.ITrowel;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.api.v3.ICrossOverResult;
import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.compatibility.applecore.AppleCoreHelper;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.PlantStats;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationEngine;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.statstringdisplayer.StatStringDisplayer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrop
extends TileEntityAgricraft
implements ICrop,
IDebuggable {
    private PlantStats stats = new PlantStats();
    private boolean crossCrop = false;
    private boolean weed = false;
    private CropPlant plant;
    private IAdditionalCropData data;
    private final MutationEngine mutationEngine = new MutationEngine(this);

    @Override
    public boolean isRotatable() {
        return false;
    }

    @Override
    public CropPlant getPlant() {
        return this.plant;
    }

    @Override
    public ISeedStats getStats() {
        return this.hasPlant() ? this.stats.copy() : new PlantStats(-1, -1, -1);
    }

    @Override
    public short getGrowth() {
        return this.weed ? (short)ConfigurationHandler.weedGrowthMultiplier : this.stats.getGrowth();
    }

    @Override
    public short getGain() {
        return this.stats.getGain();
    }

    @Override
    public short getStrength() {
        return this.stats.getStrength();
    }

    @Override
    public boolean isAnalyzed() {
        return this.stats.isAnalyzed();
    }

    @Override
    public boolean hasWeed() {
        return this.weed;
    }

    @Override
    public boolean isCrossCrop() {
        return this.crossCrop;
    }

    @Override
    public void setCrossCrop(boolean status) {
        if (status != this.crossCrop) {
            this.crossCrop = status;
            if (!this.field_145850_b.field_72995_K && this.crossCrop) {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), Blocks.field_150344_f.field_149762_H.func_150496_b(), (Blocks.field_150362_t.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150362_t.field_149762_H.func_150494_d() * 0.8f);
            }
            this.markForUpdate();
        }
    }

    public int getGrowthRate() {
        return this.weed ? ConfigurationHandler.weedGrowthRate : this.plant.getGrowthRate();
    }

    @Override
    public boolean hasPlant() {
        return this.plant != null;
    }

    @Override
    public boolean canPlant() {
        return !this.hasPlant() && !this.hasWeed() && !this.isCrossCrop();
    }

    public void setPlant(int growth, int gain, int strength, boolean analyzed, CropPlant plant) {
        if (!this.crossCrop && !this.hasPlant() && plant != null) {
            this.plant = plant;
            this.stats = new PlantStats(growth, gain, strength, analyzed);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            plant.onSeedPlanted(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
            IAdditionalCropData data = plant.getInitialCropData(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
            if (data != null) {
                this.data = data;
            }
            this.markForUpdate();
        }
    }

    @Override
    public void setPlant(int growth, int gain, int strength, boolean analyzed, Item seed, int seedMeta) {
        this.setPlant(growth, gain, strength, analyzed, CropPlantHandler.getPlantFromStack(new ItemStack(seed, 1, seedMeta)));
        if (this.plant != null) {
            this.plant.onSeedPlanted(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
        }
    }

    @Override
    public void clearPlant() {
        CropPlant oldPlant = this.getPlant();
        this.stats = new PlantStats();
        this.plant = null;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        this.markForUpdate();
        if (oldPlant != null) {
            oldPlant.onPlantRemoved(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
        }
        this.data = null;
    }

    @Override
    public boolean isFertile() {
        return this.weed || this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && this.plant.getGrowthRequirement().canGrow(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCropHeight() {
        return this.hasPlant() ? this.plant.getHeight(this.func_145832_p()) : 0.8125f;
    }

    @Override
    public boolean canBonemeal() {
        if (this.crossCrop) {
            return ConfigurationHandler.bonemealMutation;
        }
        if (this.hasPlant() && !this.isMature()) {
            if (!this.isFertile()) {
                return false;
            }
            return this.plant.canBonemeal();
        }
        return this.hasWeed() && !this.isMature();
    }

    @Override
    public boolean isMature() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) >= 7;
    }

    public ArrayList<ItemStack> getFruits() {
        return this.plant.getFruitsOnHarvest(this.getGain(), this.field_145850_b.field_73012_v);
    }

    public boolean allowHarvest(EntityPlayer player) {
        return this.hasPlant() && this.isMature() && this.plant.onHarvest(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this, player);
    }

    @Override
    public ItemStack getSeedStack() {
        if (this.plant == null) {
            return null;
        }
        ItemStack seed = this.plant.getSeed().func_77946_l();
        NBTTagCompound tag = new NBTTagCompound();
        CropPlantHandler.setSeedNBT(tag, this.getGrowth(), this.getGain(), this.getStrength(), this.stats.isAnalyzed());
        seed.func_77982_d(tag);
        return seed;
    }

    @Override
    public Block getPlantBlock() {
        return this.plant == null ? null : this.plant.getBlock();
    }

    @Override
    public void spawnWeed() {
        this.crossCrop = false;
        this.weed = true;
        this.clearPlant();
    }

    @Override
    public void spreadWeed() {
        List<ICrop> neighbours = this.getNeighbours();
        for (ICrop crop : neighbours) {
            if (crop == null || crop.hasWeed() || !(Math.random() < this.getWeedSpawnChance(crop))) continue;
            crop.spawnWeed();
            break;
        }
    }

    @Override
    public void updateWeed(int growthStage) {
        if (this.hasWeed()) {
            int n = growthStage > 7 ? 7 : (growthStage = growthStage < 0 ? 0 : growthStage);
            if (growthStage == 0) {
                this.weed = false;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, growthStage, 3);
        }
    }

    @Override
    public void clearWeed() {
        this.updateWeed(0);
    }

    private double getWeedSpawnChance(ICrop crop) {
        if (this.hasPlant()) {
            return ConfigurationHandler.weedsWipePlants ? (double)(10 - crop.getStrength()) / 10.0 : 0.0;
        }
        return crop.hasWeed() ? 0.0 : 1.0;
    }

    public void onTrowelUsed(ITrowel trowel, ItemStack trowelStack) {
        if (this.hasPlant()) {
            if (!trowel.hasSeed(trowelStack)) {
                trowel.setSeed(trowelStack, this.getSeedStack(), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.clearPlant();
            }
        } else if (!this.hasWeed() && !this.crossCrop && trowel.hasSeed(trowelStack)) {
            ItemStack seed = trowel.getSeed(trowelStack);
            int growthStage = trowel.getGrowthStage(trowelStack);
            NBTTagCompound tag = seed.func_77978_p();
            short growth = tag.func_74765_d("growth");
            short gain = tag.func_74765_d("gain");
            short strength = tag.func_74765_d("strength");
            boolean analysed = tag.func_74767_n("analyzed");
            this.setPlant(growth, gain, strength, analysed, seed.func_77973_b(), seed.func_77960_j());
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, growthStage, 3);
            trowel.clearSeed(trowelStack);
        }
    }

    @Override
    public boolean allowFertiliser(IFertiliser fertiliser) {
        if (this.crossCrop) {
            return ConfigurationHandler.bonemealMutation && fertiliser.canTriggerMutation();
        }
        if (this.hasWeed()) {
            return true;
        }
        if (this.hasPlant()) {
            return fertiliser.isFertiliserAllowed(this.plant.getTier());
        }
        return false;
    }

    @Override
    public void applyFertiliser(IFertiliser fertiliser, Random rand) {
        if (fertiliser.hasSpecialBehaviour()) {
            fertiliser.onFertiliserApplied(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, rand);
        }
        if (this.hasPlant() || this.hasWeed()) {
            ((BlockCrop)com.InfinityRaider.AgriCraft.init.Blocks.blockCrop).func_149853_b(this.field_145850_b, rand, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.isCrossCrop() && ConfigurationHandler.bonemealMutation) {
            this.crossOver();
        }
    }

    @Override
    public boolean harvest(@Nullable EntityPlayer player) {
        return ((BlockCrop)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)).harvest(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, player, this);
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public IAdditionalCropData getAdditionalCropData() {
        return this.data;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.hasPlant()) {
            this.plant.onValidate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hasPlant()) {
            this.plant.onInvalidate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hasPlant()) {
            this.plant.onChunkUnload(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.stats.writeToNBT(tag);
        tag.func_74757_a("crossCrop", this.crossCrop);
        tag.func_74757_a("weed", this.weed);
        if (this.plant != null) {
            tag.func_74782_a("seed", (NBTBase)CropPlantHandler.writePlantToNBT(this.plant));
            if (this.getAdditionalCropData() != null) {
                tag.func_74782_a("agricraftInv", (NBTBase)this.getAdditionalCropData().writeToNBT());
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.stats = PlantStats.readFromNBT(tag);
        this.crossCrop = tag.func_74767_n("crossCrop");
        this.weed = tag.func_74767_n("weed");
        if (tag.func_74764_b("seed") && !tag.func_74764_b("meta")) {
            this.plant = CropPlantHandler.readPlantFromNBT(tag.func_74775_l("seed"));
        } else if (tag.func_74764_b("seed") && tag.func_74764_b("meta")) {
            this.loadPlantFromOldVersion(tag);
        } else {
            this.plant = null;
        }
        if (tag.func_74764_b("agricraftInv") && this.plant != null) {
            this.data = this.plant.readCropDataFromNBT(tag.func_74775_l("agricraftInv"));
        }
    }

    @Deprecated
    private void loadPlantFromOldVersion(NBTTagCompound tag) {
        int meta;
        String name = tag.func_74779_i("seed");
        Item seed = name.equalsIgnoreCase("none") ? null : (Item)Item.field_150901_e.func_82594_a(name);
        ItemStack stack = new ItemStack(seed, 1, meta = tag.func_74762_e("meta"));
        CropPlant plant = CropPlantHandler.getPlantFromStack(stack);
        if (plant != null) {
            this.plant = plant;
        } else {
            LogHelper.info("Couldn't find plant for " + stack.func_77977_a() + " at (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + "), plant has been removed");
            this.clearPlant();
        }
    }

    public void applyGrowthTick() {
        int flag = 2;
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.hasPlant()) {
            int n = flag = this.plant.onAllowedGrowthTick(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, this) ? 2 : 6;
        }
        if (ConfigurationHandler.renderCropPlantsAsTESR) {
            flag = 6;
        }
        if (this.hasWeed() || !this.plant.isMature((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta + 1, flag);
            AppleCoreHelper.announceGrowthTick(this.func_145838_q(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void crossOver() {
        this.mutationEngine.executeCrossOver();
    }

    public void applyCrossOverResult(ICrossOverResult result, ISeedStats stats) {
        this.crossCrop = false;
        this.setPlant(stats.getGrowth(), stats.getGain(), stats.getStrength(), false, result.getSeed(), result.getMeta());
    }

    @Override
    public List<ICrop> getNeighbours() {
        ArrayList<ICrop> neighbours = new ArrayList<ICrop>();
        this.addNeighbour(neighbours, ForgeDirection.NORTH);
        this.addNeighbour(neighbours, ForgeDirection.SOUTH);
        this.addNeighbour(neighbours, ForgeDirection.EAST);
        this.addNeighbour(neighbours, ForgeDirection.WEST);
        return neighbours;
    }

    private void addNeighbour(List<ICrop> neighbours, ForgeDirection direction) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return;
        }
        neighbours.add((TileEntityCrop)te);
    }

    @Override
    public List<ICrop> getMatureNeighbours() {
        List<ICrop> neighbours = this.getNeighbours();
        Iterator<ICrop> iterator = neighbours.iterator();
        while (iterator.hasNext()) {
            ICrop crop = iterator.next();
            if (crop.hasPlant() && crop.isMature()) continue;
            iterator.remove();
        }
        return neighbours;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon() {
        IIcon icon = null;
        if (this.hasPlant()) {
            icon = this.plant.getPlantIcon(this.func_145832_p());
        } else if (this.weed) {
            icon = ((BlockCrop)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)).getWeedIcon(this.func_145832_p());
        }
        return icon;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        list.add("CROP:");
        if (this.crossCrop) {
            list.add(" - This is a crosscrop");
        } else if (this.hasPlant()) {
            list.add(" - This crop has a plant");
            list.add(" - Seed: " + this.plant.getSeed().func_77973_b().func_77658_a());
            list.add(" - Seed class: " + this.plant.getSeed().func_77973_b().getClass().getName());
            list.add(" - RegisterName: " + Item.field_150901_e.func_148750_c((Object)this.plant.getSeed().func_77973_b()) + ":" + this.plant.getSeed().func_77960_j());
            list.add(" - Tier: " + this.plant.getTier());
            list.add(" - Meta: " + this.func_145832_p());
            list.add(" - Growth: " + this.getGrowth());
            list.add(" - Gain: " + this.getGain());
            list.add(" - Strength: " + this.getStrength());
            list.add(" - Fertile: " + this.isFertile());
            list.add(" - Mature: " + this.isMature());
        } else if (this.weed) {
            list.add(" - This crop has weeds");
            list.add(" - Meta: " + this.func_145832_p());
        } else {
            list.add(" - This crop has no plant");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWailaInformation(List information) {
        if (this.hasPlant()) {
            information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.seed") + ": " + this.getSeedStack().func_82833_r());
            if (this.isMature()) {
                information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.growthStage") + ": " + StatCollector.func_74838_a((String)"agricraft_tooltip.mature"));
            } else {
                information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.growthStage") + ": " + (int)(100.0f * ((float)this.func_145832_p() + 0.0f) / 7.0f) + "%");
            }
            if (this.isAnalyzed()) {
                information.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.growth") + ": " + StatStringDisplayer.instance().getStatDisplayString(this.getGrowth(), ConfigurationHandler.cropStatCap));
                information.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.gain") + ": " + StatStringDisplayer.instance().getStatDisplayString(this.getGain(), ConfigurationHandler.cropStatCap));
                information.add(" - " + StatCollector.func_74838_a((String)"agricraft_tooltip.strength") + ": " + StatStringDisplayer.instance().getStatDisplayString(this.getStrength(), ConfigurationHandler.cropStatCap));
            } else {
                information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.analyzed"));
            }
            information.add(StatCollector.func_74838_a((String)(this.isFertile() ? "agricraft_tooltip.fertile" : "agricraft_tooltip.notFertile")));
        } else if (this.hasWeed()) {
            information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.weeds"));
        } else {
            information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.empty"));
        }
    }
}

