/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import com.InfinityRaider.AgriCraft.items.ItemNugget;
import com.InfinityRaider.AgriCraft.reference.Data;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class OreDictHelper {
    private static final Map<String, Block> oreBlocks = new HashMap<String, Block>();
    private static final Map<String, Integer> oreBlockMeta = new HashMap<String, Integer>();
    private static final Map<String, Item> nuggets = new HashMap<String, Item>();
    private static final Map<String, Integer> nuggetMeta = new HashMap<String, Integer>();

    public static Block getOreBlockForName(String name) {
        return oreBlocks.get(name);
    }

    public static int getOreMetaForName(String name) {
        return oreBlockMeta.get(name);
    }

    public static Item getNuggetForName(String name) {
        return nuggets.get(name);
    }

    public static int getNuggetMetaForName(String name) {
        return nuggetMeta.get(name);
    }

    public static boolean hasOreId(ItemStack stack, String tag) {
        int[] ids;
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).equals(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOreId(Block block, String tag) {
        return block != null && OreDictHelper.hasOreId(new ItemStack(block), tag);
    }

    public static boolean isSameOre(Block block1, int meta1, Block block2, int meta2) {
        if (block1 == block2 && meta1 == meta2) {
            return true;
        }
        if (block1 == null || block2 == null) {
            return false;
        }
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)new ItemStack(block1, 1, meta1));
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)new ItemStack(block2, 1, meta2));
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getIngot(String ore) {
        ItemStack ingot = null;
        ArrayList entries = OreDictionary.getOres((String)("ingot" + ore));
        if (entries.size() > 0 && ((ItemStack)entries.get(0)).func_77973_b() != null) {
            ingot = (ItemStack)entries.get(0);
        }
        return ingot;
    }

    public static void getRegisteredOres() {
        for (String string : Data.vanillaNuggets) {
            OreDictHelper.getOreBlock(string);
            if (oreBlocks.get(string) == null) continue;
            OreDictHelper.getNugget(string);
        }
        for (String string : Data.modResources) {
            String oreName = string[0];
            OreDictHelper.getOreBlock(oreName);
            if (oreBlocks.get(oreName) == null) continue;
            OreDictHelper.getNugget(oreName);
        }
    }

    private static void getOreBlock(String oreName) {
        for (ItemStack itemStack : OreDictionary.getOres((String)("ore" + oreName))) {
            if (!(itemStack.func_77973_b() instanceof ItemBlock)) continue;
            ItemBlock block = (ItemBlock)itemStack.func_77973_b();
            oreBlocks.put(oreName, block.field_150939_a);
            oreBlockMeta.put(oreName, itemStack.func_77960_j());
            break;
        }
    }

    private static void getNugget(String oreName) {
        ArrayList nuggets = OreDictionary.getOres((String)("nugget" + oreName));
        if (!nuggets.isEmpty()) {
            Item nugget = ((ItemStack)nuggets.get(0)).func_77973_b();
            OreDictHelper.nuggets.put(oreName, nugget);
            nuggetMeta.put(oreName, ((ItemStack)nuggets.get(0)).func_77960_j());
        } else {
            ItemNugget nugget = new ItemNugget(oreName);
            OreDictionary.registerOre((String)("nugget" + oreName), (Item)nugget);
            OreDictHelper.nuggets.put(oreName, nugget);
            nuggetMeta.put(oreName, 0);
        }
    }

    public static ArrayList<ItemStack> getFruitsFromOreDict(ItemStack seed) {
        return OreDictHelper.getFruitsFromOreDict(seed, true);
    }

    public static ArrayList<ItemStack> getFruitsFromOreDict(ItemStack seed, boolean sameMod) {
        String seedModId = IOHelper.getModId(seed);
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        for (int id : OreDictionary.getOreIDs((ItemStack)seed)) {
            if (!OreDictionary.getOreName((int)id).substring(0, 4).equalsIgnoreCase("seed")) continue;
            String name = OreDictionary.getOreName((int)id).substring(4);
            ArrayList fromOredict = OreDictionary.getOres((String)("crop" + name));
            for (ItemStack stack : fromOredict) {
                if (stack == null || stack.func_77973_b() == null) continue;
                String stackModId = IOHelper.getModId(stack);
                if (sameMod && !seedModId.equals(stackModId)) continue;
                fruits.add(stack);
            }
        }
        return fruits;
    }
}

