/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.bigreactors;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.crossmod.bigreactors.TileEntityBlockFetcher;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardEnergySensorLocation;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class ItemCardRFSensor
extends ItemCardEnergySensorLocation {
    public static final int DISPLAY_ON = 1;
    public static final int DISPLAY_OUTPUT = 2;
    public static final int DISPLAY_ENERGY = 4;
    public static final int DISPLAY_PERCENTAGE = 8;
    public static final int DISPLAY_TEMP = 16;
    public static final UUID CARD_TYPE1 = new UUID(0L, 2L);

    public ItemCardRFSensor() {
        this.func_111206_d("nuclearcontrol:cardRFReactor");
    }

    @Override
    public UUID getCardType() {
        return CARD_TYPE1;
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity check = panel.func_145831_w().func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (check instanceof TileEntityBlockFetcher) {
            TileEntityBlockFetcher BF = (TileEntityBlockFetcher)check;
            card.setBoolean("Online", BF.isReactorOnline());
            card.setDouble("storedEnergy", Double.valueOf(BF.getEnergyStored()));
            card.setDouble("createdEnergy", Double.valueOf(BF.getEnergyGenerated()));
            card.setInt("Temp", BF.getTemp());
            card.setDouble("FillPercent", Double.valueOf(BF.getEnergyOutPercent()));
            card.setBoolean("isPassive", BF.getReactorController().isPassivelyCooled());
            if (!BF.getReactorController().isPassivelyCooled()) {
                if (BF.getReactorController().getCoolantContainer().getVaporType() != null) {
                    card.setString("VaporType", BF.getReactorController().getCoolantContainer().getVaporType().getLocalizedName());
                    card.setInt("VaporAmount", BF.getReactorController().getCoolantContainer().getVaporAmount());
                } else {
                    card.setString("VaporType", "Empty");
                    card.setInt("VaporAmount", 0);
                }
                if (BF.getReactorController().getCoolantContainer().getCoolantType() != null) {
                    card.setString("CoolantType", new FluidStack(BF.getReactorController().getCoolantContainer().getCoolantType(), 1).getLocalizedName());
                    card.setInt("CoolantAmount", BF.getReactorController().getCoolantContainer().getCoolantAmount());
                } else {
                    card.setString("CoolantType", "Empty");
                    card.setInt("CoolantAmount", 0);
                }
            }
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity check = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (check instanceof TileEntityBlockFetcher) {
            TileEntityBlockFetcher BF = (TileEntityBlockFetcher)check;
            card.setBoolean("Online", BF.isReactorOnline());
            card.setDouble("storedEnergy", Double.valueOf(BF.getEnergyStored()));
            card.setDouble("createdEnergy", Double.valueOf(BF.getEnergyGenerated()));
            card.setInt("Temp", BF.getTemp());
            card.setDouble("FillPercent", Double.valueOf(BF.getEnergyOutPercent()));
            card.setBoolean("isPassive", BF.getReactorController().isPassivelyCooled());
            if (!BF.getReactorController().isPassivelyCooled()) {
                if (BF.getReactorController().getCoolantContainer().getVaporType() != null) {
                    card.setString("VaporType", BF.getReactorController().getCoolantContainer().getVaporType().getLocalizedName());
                    card.setInt("VaporAmount", BF.getReactorController().getCoolantContainer().getVaporAmount());
                } else {
                    card.setString("VaporType", "Empty");
                    card.setInt("VaporAmount", 0);
                }
                if (BF.getReactorController().getCoolantContainer().getCoolantType() != null) {
                    card.setString("CoolantType", new FluidStack(BF.getReactorController().getCoolantContainer().getCoolantType(), 1).getLocalizedName());
                    card.setInt("CoolantAmount", BF.getReactorController().getCoolantContainer().getCoolantAmount());
                } else {
                    card.setString("CoolantType", "Empty");
                    card.setInt("CoolantAmount", 0);
                }
            }
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        double PerOut = card.getDouble("FillPercent");
        double energyStored = card.getDouble("storedEnergy");
        double outputlvl = card.getDouble("createdEnergy");
        double coreTemp = card.getDouble("Temp");
        int ioutputlvl = (int)outputlvl;
        int ienergyStored = (int)energyStored;
        boolean passive = card.getBoolean("isPassive");
        if (passive) {
            PanelString line;
            if ((displaySettings & 0x10) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelRF.Temp", coreTemp, showLabels);
                result.add(line);
            }
            if ((displaySettings & 4) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelRF.EnergyStored", ienergyStored, showLabels);
                result.add(line);
            }
            if ((displaySettings & 2) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelRF.CreatedEnergy", ioutputlvl, showLabels);
                result.add(line);
            }
            if ((displaySettings & 8) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelRF.Percentage", PerOut, showLabels);
                result.add(line);
            }
            int txtColor = 0;
            if ((displaySettings & 1) > 0) {
                String text;
                boolean reactorPowered = card.getBoolean("Online");
                if (reactorPowered) {
                    txtColor = 65280;
                    text = LangHelper.translate("msg.nc.InfoPanelOn");
                } else {
                    txtColor = 0xFF0000;
                    text = LangHelper.translate("msg.nc.InfoPanelOff");
                }
                if (result.size() > 0) {
                    PanelString firstLine = (PanelString)result.get(0);
                    firstLine.textRight = text;
                    firstLine.colorRight = txtColor;
                } else {
                    line = new PanelString();
                    line.textLeft = text;
                    line.colorLeft = txtColor;
                    result.add(line);
                }
            }
        } else {
            PanelString line;
            if ((displaySettings & 0x10) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelRF.Temp", coreTemp, showLabels);
                result.add(line);
            }
            if ((displaySettings & 2) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelRF.SteamOutput", ioutputlvl, showLabels);
                result.add(line);
            }
            if ((displaySettings & 4) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormattedKey("msg.nc.InfoPanelRF.CoolantTank", card.getString("CoolantType"), card.getInt("CoolantAmount"));
                result.add(line);
            }
            if ((displaySettings & 8) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormattedKey("msg.nc.InfoPanelRF.OutputTank", card.getString("VaporType"), card.getInt("VaporAmount"));
                result.add(line);
            }
            int txtColor = 0;
            if ((displaySettings & 1) > 0) {
                String text;
                boolean reactorPowered = card.getBoolean("Online");
                if (reactorPowered) {
                    txtColor = 65280;
                    text = LangHelper.translate("msg.nc.InfoPanelOn");
                } else {
                    txtColor = 0xFF0000;
                    text = LangHelper.translate("msg.nc.InfoPanelOff");
                }
                if (result.size() > 0) {
                    PanelString firstLine = (PanelString)result.get(0);
                    firstLine.textRight = text;
                    firstLine.colorRight = txtColor;
                } else {
                    line = new PanelString();
                    line.textLeft = text;
                    line.colorLeft = txtColor;
                    result.add(line);
                }
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelOnOff"), 1, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelEnergyCurrent"), 4, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanelRF.Output"), 2, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.InfoPanelRF.TempPROPER"), 16, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.cbInfoPanelEnergyPercentage"), 8, CARD_TYPE));
        return result;
    }
}

