/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.tileentities;

import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.items.ItemUpgrade;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;

public class TileEntityAdvancedInfoPanel
extends TileEntityInfoPanel {
    private byte prevPowerMode;
    public byte powerMode;
    private byte prevThickness;
    public byte thickness;
    private byte prevRotateHor;
    public byte rotateHor;
    private byte prevRotateVert;
    public byte rotateVert;
    public ItemStack card2;
    public ItemStack card3;
    private static final byte SLOT_CARD1 = 0;
    private static final byte SLOT_CARD2 = 1;
    private static final byte SLOT_CARD3 = 2;
    private static final byte SLOT_UPGRADE_RANGE = 3;
    private static final byte SLOT_UPGRADE_WEB = 3;
    public static final int POWER_REDSTONE = 0;
    public static final int POWER_INVERTED = 1;
    public static final int POWER_ON = 2;
    public static final int POWER_OFF = 3;
    public static final int OFFSET_THICKNESS = 100;
    public static final int OFFSET_ROTATE_HOR = 200;
    public static final int OFFSET_ROTATE_VERT = 300;

    public TileEntityAdvancedInfoPanel() {
        super(4);
        this.colored = true;
        this.thickness = (byte)16;
    }

    @Override
    public int getCardSlotsCount() {
        return 3;
    }

    public byte getPowerMode() {
        return this.powerMode;
    }

    public void setPowerMode(byte p) {
        this.powerMode = p;
        if (this.prevPowerMode != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "powerMode");
        }
        this.prevPowerMode = this.powerMode;
    }

    public void setThickness(byte p) {
        this.thickness = p;
        if (this.prevThickness != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "thickness");
        }
        this.prevThickness = this.thickness;
    }

    public byte getThickness() {
        return this.thickness;
    }

    public void setRotateHor(byte p) {
        this.rotateHor = p;
        if (this.prevRotateHor != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotateHor");
        }
        this.prevRotateHor = this.rotateHor;
    }

    public byte getRotationHor() {
        return this.rotateHor;
    }

    public void setRotateVert(byte p) {
        this.rotateVert = p;
        if (this.prevRotateVert != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotateVert");
        }
        this.prevRotateVert = this.rotateVert;
    }

    public byte getRotationVert() {
        return this.rotateVert;
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> list = super.getNetworkedFields();
        list.add("card2");
        list.add("card3");
        list.add("powerMode");
        list.add("thickness");
        list.add("rotateHor");
        list.add("rotateVert");
        return list;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("card2")) {
            this.inventory[1] = this.card2;
        } else if (field.equals("card3")) {
            this.inventory[2] = this.card3;
        } else if (field.equals("powerMode") && this.prevPowerMode != this.powerMode) {
            if (this.screen != null) {
                this.screen.turnPower(this.getPowered(), this.field_145850_b);
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.prevPowerMode = this.powerMode;
        } else if (field.equals("thickness") || field.equals("rotateHor") || field.equals("rotateVert")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemstack) {
        switch (slotIndex) {
            case 0: 
            case 1: 
            case 2: {
                return itemstack.func_77973_b() instanceof IPanelDataSource;
            }
            case 3: {
                return itemstack.func_77973_b() instanceof ItemUpgrade && (itemstack.func_77960_j() == 0 || itemstack.func_77960_j() == 2);
            }
        }
        return false;
    }

    @Override
    protected boolean isColoredEval() {
        return true;
    }

    @Override
    protected boolean isWebEval() {
        ItemStack itemStack = this.inventory[3];
        return itemStack != null && itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77960_j() == 2;
    }

    @Override
    protected ItemStack getRangeUpgrade() {
        return this.inventory[3];
    }

    @Override
    public List<ItemStack> getCards() {
        ArrayList<ItemStack> data = new ArrayList<ItemStack>(3);
        data.add(this.inventory[0]);
        data.add(this.inventory[1]);
        data.add(this.inventory[2]);
        return data;
    }

    @Override
    protected boolean isCardSlot(int slot) {
        return slot == 0 || slot == 1 || slot == 2;
    }

    @Override
    protected void saveDisplaySettings(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("dSettings1", (NBTBase)this.serializeSlotSettings((byte)0));
        nbttagcompound.func_74782_a("dSettings2", (NBTBase)this.serializeSlotSettings((byte)1));
        nbttagcompound.func_74782_a("dSettings3", (NBTBase)this.serializeSlotSettings((byte)2));
        nbttagcompound.func_74774_a("rotateHor", this.rotateHor);
        nbttagcompound.func_74774_a("rotateVert", this.rotateVert);
        nbttagcompound.func_74774_a("thickness", this.thickness);
        nbttagcompound.func_74774_a("powerMode", this.powerMode);
    }

    @Override
    protected void readDisplaySettings(NBTTagCompound nbttagcompound) {
        this.deserializeDisplaySettings(nbttagcompound, "dSettings1", (byte)0);
        this.deserializeDisplaySettings(nbttagcompound, "dSettings2", (byte)1);
        this.deserializeDisplaySettings(nbttagcompound, "dSettings3", (byte)2);
        this.rotateHor = nbttagcompound.func_74771_c("rotateHor");
        this.rotateVert = nbttagcompound.func_74771_c("rotateVert");
        this.thickness = nbttagcompound.func_74771_c("thickness");
        this.powerMode = nbttagcompound.func_74771_c("powerMode");
    }

    @Override
    protected void postReadFromNBT() {
        if (this.inventory[0] != null) {
            this.card = this.inventory[0];
        }
        if (this.inventory[1] != null) {
            this.card2 = this.inventory[1];
        }
        if (this.inventory[2] != null) {
            this.card3 = this.inventory[2];
        }
    }

    public byte getNextPowerMode() {
        switch (this.powerMode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean getPowered() {
        switch (this.powerMode) {
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 0: {
                return this.powered;
            }
            case 1: {
                return !this.powered;
            }
        }
        return false;
    }

    @Override
    public void onNetworkEvent(EntityPlayer entityplayer, int i) {
        super.onNetworkEvent(entityplayer, i);
        if (i >= 0 && i < 100) {
            switch (i) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.setPowerMode((byte)i);
                }
            }
        } else if (i >= 100 && i < 200) {
            this.setThickness((byte)(i -= 100));
        } else if (i >= 200 && i < 300) {
            i -= 208;
            i = -(i * 7);
            this.setRotateHor((byte)i);
        } else if (i >= 300 && i < 400) {
            i -= 308;
            i = -(i * 7);
            this.setRotateVert((byte)i);
        }
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)IC2NuclearControl.blockNuclearControlMain, 1, 9);
    }
}

