/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.gui.elements;

import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.render.ItemStackRenderer;
import code.elix_x.excore.utils.color.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public abstract class GuiElement<H extends IGuiElementsHandler<? extends IGuiElement<H>>>
implements IGuiElement<H> {
    protected String name;

    public GuiElement(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ScaledResolution screenResolution() {
        return new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
    }

    public int screenWidth() {
        return this.screenResolution().func_78326_a();
    }

    public int screenHeight() {
        return this.screenResolution().func_78328_b();
    }

    public int toLocal(int screen) {
        return screen / this.screenResolution().func_78325_e();
    }

    public int toScreen(int local) {
        return local * this.screenResolution().func_78325_e();
    }

    public Rectangle screen() {
        return new Rectangle(0, 0, this.screenWidth(), this.screenHeight());
    }

    public int mouseX() {
        return this.toLocal(Mouse.getX());
    }

    public int mouseY() {
        return this.screenHeight() - this.toLocal(Mouse.getY()) - 1;
    }

    public Rectangle cursor(int mouseX, int mouseY) {
        return new Rectangle(mouseX, mouseY, 8, 8);
    }

    public int right(Rectangle element) {
        return element.getX() + element.getWidth();
    }

    public int bottom(Rectangle element) {
        return element.getY() + element.getHeight();
    }

    public Rectangle smartPos(Rectangle screen, Rectangle element) {
        if (element.getWidth() > screen.getWidth() || element.getHeight() > screen.getHeight()) {
            throw new IllegalArgumentException("Element larger than screen");
        }
        if (element.getX() < screen.getX()) {
            element.setX(screen.getX());
        }
        if (element.getY() < screen.getY()) {
            element.setY(screen.getY());
        }
        if (this.right(element) > this.right(screen)) {
            element.setX(this.right(screen) - element.getWidth());
        }
        if (this.bottom(element) > this.bottom(screen)) {
            element.setY(this.bottom(screen) - element.getHeight());
        }
        return element;
    }

    public Rectangle smartPos(Rectangle screen, Rectangle cursor, Rectangle element, boolean alignLeft, boolean alignTop) {
        if ((element = this.smartPos(screen, element)).intersects((ReadableRectangle)cursor)) {
            if (this.right(element) > cursor.getX() && element.getX() < this.right(cursor)) {
                if (cursor.getX() - screen.getX() < element.getWidth()) {
                    alignLeft = false;
                }
                if (this.right(screen) - this.right(cursor) < element.getWidth()) {
                    alignLeft = true;
                }
                if (alignLeft) {
                    element.setX(cursor.getX() - element.getWidth());
                } else {
                    element.setX(this.right(cursor));
                }
            }
            if (this.bottom(element) > cursor.getY() && element.getY() < this.bottom(cursor)) {
                if (cursor.getY() - screen.getY() < element.getHeight()) {
                    alignTop = false;
                }
                if (this.bottom(screen) - this.bottom(cursor) < element.getHeight()) {
                    alignTop = true;
                }
                if (alignTop) {
                    element.setY(cursor.getY() - element.getHeight());
                } else {
                    element.setY(this.bottom(cursor));
                }
            }
        }
        return element;
    }

    public void drawColoredRect(Rectangle element, RGBA color, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)color.getRF(), (float)color.getGF(), (float)color.getBF(), (float)color.getAF());
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)element.getX(), (double)this.bottom(element), zLevel);
        tessellator.func_78377_a((double)this.right(element), (double)this.bottom(element), zLevel);
        tessellator.func_78377_a((double)this.right(element), (double)element.getY(), zLevel);
        tessellator.func_78377_a((double)element.getX(), (double)element.getY(), zLevel);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void drawColoredRect(Rectangle element, RGBA color) {
        this.drawColoredRect(element, color, 0.0);
    }

    public void drawTexturedRect(Rectangle element, Rectangle texture, int textureWidth, int textureHeight, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        float uScale = 1.0f / (float)textureWidth;
        float vScale = 1.0f / (float)textureHeight;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)element.getX(), (double)this.bottom(element), zLevel, (double)((float)texture.getX() * uScale), (double)((float)this.bottom(texture) * vScale));
        tessellator.func_78374_a((double)this.right(element), (double)this.bottom(element), zLevel, (double)((float)this.right(texture) * uScale), (double)((float)this.bottom(texture) * vScale));
        tessellator.func_78374_a((double)this.right(element), (double)element.getY(), zLevel, (double)((float)this.right(texture) * uScale), (double)((float)texture.getY() * vScale));
        tessellator.func_78374_a((double)element.getX(), (double)element.getY(), zLevel, (double)((float)texture.getX() * uScale), (double)((float)texture.getY() * vScale));
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public void drawTexturedRect(Rectangle element, Rectangle texture, int textureWidth, int textureHeight) {
        this.drawTexturedRect(element, texture, textureWidth, textureHeight, 0.0);
    }

    public void scissorsPre() {
        GL11.glEnable((int)3089);
    }

    public void scisors(Rectangle element) {
        GL11.glScissor((int)this.toScreen(element.getX()), (int)this.toScreen(this.screenHeight() - element.getY() - element.getHeight()), (int)this.toScreen(element.getWidth()), (int)this.toScreen(element.getHeight()));
    }

    public void scissorsPost() {
        GL11.glDisable((int)3089);
    }

    public void drawStringPre() {
    }

    public void drawString(FontRenderer font, String text, int x, int y, RGBA color) {
        font.func_78261_a(text, x, y, color.argb());
    }

    public void drawStringPost() {
    }

    public void drawStringFull(FontRenderer font, String text, int x, int y, RGBA color) {
        this.drawStringPre();
        this.drawString(font, text, x, y, color);
        this.drawStringPost();
    }

    public void renderItemStackPre() {
        RenderHelper.func_74520_c();
    }

    public void renderItemStack(ItemStack itemstack, int x, int y) {
        ItemStackRenderer.renderItemStack(Minecraft.func_71410_x(), x, y, itemstack);
    }

    public void renderItemStackPost() {
        RenderHelper.func_74518_a();
    }

    public void renderItemStackFull(ItemStack itemstack, int x, int y) {
        this.renderItemStackPre();
        this.renderItemStack(itemstack, x, y);
        this.renderItemStackPost();
    }

    public int maxWidth(FontRenderer font, String ... ss) {
        int max = 0;
        for (String s : ss) {
            max = Math.max(max, font.func_78256_a(s));
        }
        return max;
    }

    public String[] translate(String ... strings) {
        String[] trans = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            trans[i] = StatCollector.func_74838_a((String)strings[i]);
        }
        return trans;
    }

    public void drawStandartTooltipBackground(Rectangle element) {
    }

    public void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, boolean background, boolean translate, String ... tooltips) {
        if (translate) {
            tooltips = this.translate(tooltips);
        }
        Rectangle tooltip = this.smartPos(this.screen(), this.cursor(mouseX, mouseY), new Rectangle(mouseX, mouseY, this.maxWidth(font, tooltips), tooltips.length * (8 + verticalTextSpace) - verticalTextSpace), alignLeft, alignTop);
        if (background) {
            this.drawStandartTooltipBackground(tooltip);
        }
        this.drawStringPre();
        for (int i = 0; i < tooltips.length; ++i) {
            this.drawString(font, tooltips[i], tooltip.getX(), tooltip.getY() + i * (8 + verticalTextSpace), textColor);
        }
        this.drawStringPost();
    }

    public void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, String ... tooltips) {
        this.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, textColor, false, false, tooltips);
    }

    public void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, RGBA textColor, String ... tooltips) {
        this.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, 2, textColor, tooltips);
    }

    public void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, String ... tooltips) {
        this.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, String ... tooltips) {
        this.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, 2, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public void drawTooltipTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, String ... tooltips) {
        this.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, textColor, false, true, tooltips);
    }

    public void drawTooltipTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, RGBA textColor, String ... tooltips) {
        this.drawTooltipTranslate(font, mouseX, mouseY, alignLeft, alignTop, 2, textColor, tooltips);
    }

    public void drawTooltipTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, String ... tooltips) {
        this.drawTooltipTranslate(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public void drawTooltipTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, String ... tooltips) {
        this.drawTooltipTranslate(font, mouseX, mouseY, alignLeft, alignTop, 2, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public void drawTooltipWithBackground(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, String ... tooltips) {
        this.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, textColor, true, false, tooltips);
    }

    public void drawTooltipWithBackground(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, RGBA textColor, String ... tooltips) {
        this.drawTooltipWithBackground(font, mouseX, mouseY, alignLeft, alignTop, 2, textColor, tooltips);
    }

    public void drawTooltipWithBackground(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, String ... tooltips) {
        this.drawTooltipWithBackground(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public void drawTooltipWithBackground(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, String ... tooltips) {
        this.drawTooltipWithBackground(font, mouseX, mouseY, alignLeft, alignTop, 2, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public void drawTooltipWithBackgroundTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, String ... tooltips) {
        this.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, textColor, true, true, tooltips);
    }

    public void drawTooltipWithBackgroundTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, RGBA textColor, String ... tooltips) {
        this.drawTooltipWithBackgroundTranslate(font, mouseX, mouseY, alignLeft, alignTop, 2, textColor, tooltips);
    }

    public void drawTooltipWithBackgroundTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, String ... tooltips) {
        this.drawTooltipWithBackgroundTranslate(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public void drawTooltipWithBackgroundTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, String ... tooltips) {
        this.drawTooltipWithBackgroundTranslate(font, mouseX, mouseY, alignLeft, alignTop, 2, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }
}

