/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.packets;

import code.elix_x.excore.utils.packets.runnable.RunnableMessageHandler;
import com.google.common.base.Function;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper;
import cpw.mods.fml.common.network.simpleimpl.SimpleIndexedCodec;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SmartNetworkWrapper {
    private final String name;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private SimpleIndexedCodec packetCodec;
    private int nextPacketId = 0;
    private Map<Class<? extends IMessage>, Side> packetsReceivingSide = new HashMap<Class<? extends IMessage>, Side>();

    public SmartNetworkWrapper(String name) {
        this.name = name;
        this.packetCodec = new SimpleIndexedCodec();
        this.channels = NetworkRegistry.INSTANCE.newChannel(name, new ChannelHandler[]{this.packetCodec});
    }

    public String getName() {
        return this.name;
    }

    public int getNextPacketId() {
        return this.nextPacketId;
    }

    public Side getPacketReceivingSide(Class<? extends IMessage> clazz) {
        return this.packetsReceivingSide.get(clazz);
    }

    public Packet getPacketFrom(IMessage message) {
        return this.channels.get(Side.SERVER).generatePacketFrom((Object)message);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, Side side) {
        this.packetCodec.addDiscriminator(this.nextPacketId, requestMessageType);
        FMLEmbeddedChannel channel = this.channels.get(side);
        String type = channel.findChannelHandlerNameForType(SimpleIndexedCodec.class);
        if (side == Side.SERVER) {
            this.addServerHandlerAfter(channel, type, messageHandler, requestMessageType);
        } else {
            this.addClientHandlerAfter(channel, type, messageHandler, requestMessageType);
        }
        this.packetsReceivingSide.put(requestMessageType, side);
        ++this.nextPacketId;
    }

    private <REQ extends IMessage, REPLY extends IMessage, NH extends INetHandler> void addServerHandlerAfter(FMLEmbeddedChannel channel, String type, IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestType) {
        SimpleChannelHandlerWrapper<? super REQ, ? extends REPLY> handler = this.getHandlerWrapper(messageHandler, Side.SERVER, requestType);
        channel.pipeline().addAfter(type, messageHandler.getClass().getName() + "#" + this.nextPacketId, handler);
    }

    private <REQ extends IMessage, REPLY extends IMessage, NH extends INetHandler> void addClientHandlerAfter(FMLEmbeddedChannel channel, String type, IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestType) {
        SimpleChannelHandlerWrapper<? super REQ, ? extends REPLY> handler = this.getHandlerWrapper(messageHandler, Side.CLIENT, requestType);
        channel.pipeline().addAfter(type, messageHandler.getClass().getName() + "#" + this.nextPacketId, handler);
    }

    private <REPLY extends IMessage, REQ extends IMessage> SimpleChannelHandlerWrapper<REQ, REPLY> getHandlerWrapper(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Side side, Class<REQ> requestType) {
        return new SimpleChannelHandlerWrapper(messageHandler, side, requestType);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Function<Pair<REQ, MessageContext>, Pair<Runnable, REPLY>> onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new RunnableMessageHandler<REQ, REPLY>(onReceive), requestMessageType, side);
    }

    public <REQ extends IMessage> void registerMessage1(final Function<Pair<REQ, MessageContext>, Runnable> onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new Function<Pair<REQ, MessageContext>, Pair<Runnable, IMessage>>(){

            public Pair<Runnable, IMessage> apply(Pair<REQ, MessageContext> t) {
                return new ImmutablePair(onReceive.apply(t), null);
            }
        }, requestMessageType, side);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage2(final Function<REQ, Pair<Runnable, REPLY>> onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new Function<Pair<REQ, MessageContext>, Pair<Runnable, REPLY>>(){

            public Pair<Runnable, REPLY> apply(Pair<REQ, MessageContext> t) {
                return (Pair)onReceive.apply(t.getKey());
            }
        }, requestMessageType, side);
    }

    public <REQ extends IMessage> void registerMessage3(final Function<REQ, Runnable> onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new Function<Pair<REQ, MessageContext>, Pair<Runnable, IMessage>>(){

            public Pair<Runnable, IMessage> apply(Pair<REQ, MessageContext> t) {
                return new ImmutablePair(onReceive.apply(t.getKey()), null);
            }
        }, requestMessageType, side);
    }

    public <REQ extends IMessage> void registerMessage(final Runnable onReceive, Class<REQ> requestMessageType, Side side) {
        this.registerMessage(new Function<Pair<REQ, MessageContext>, Pair<Runnable, IMessage>>(){

            public Pair<Runnable, IMessage> apply(Pair<REQ, MessageContext> t) {
                return new ImmutablePair((Object)onReceive, null);
            }
        }, requestMessageType, side);
    }

    public void sendToAll(IMessage message) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.CLIENT) {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.CLIENT) {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.CLIENT) {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.CLIENT) {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public void sendToServer(IMessage message) {
        if (this.packetsReceivingSide.get(message.getClass()) == Side.SERVER && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.channels.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }
}

