/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.pos;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos {
    public int x;
    public int y;
    public int z;

    private BlockPos() {
    }

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public BlockPos offset(ForgeDirection direction) {
        return this.offsetX(direction.offsetX).offsetY(direction.offsetY).offsetZ(direction.offsetZ);
    }

    public BlockPos offsetX(int xx) {
        this.x += xx;
        return this;
    }

    public BlockPos offsetY(int yy) {
        this.y += yy;
        return this;
    }

    public BlockPos offsetZ(int zz) {
        this.z += zz;
        return this;
    }

    public BlockPos offsetNew(ForgeDirection direction) {
        return this.offsetXNew(direction.offsetX).offsetYNew(direction.offsetY).offsetZNew(direction.offsetZ);
    }

    public BlockPos offsetXNew(int xx) {
        return new BlockPos(this.x + xx, this.y, this.z);
    }

    public BlockPos offsetYNew(int yy) {
        return new BlockPos(this.x, this.y + yy, this.z);
    }

    public BlockPos offsetZNew(int zz) {
        return new BlockPos(this.x, this.y, this.z + zz);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public int getMetadata(World world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.x = nbt.func_74762_e("x");
        this.y = nbt.func_74762_e("y");
        this.z = nbt.func_74762_e("z");
    }

    public static BlockPos createFromNBT(NBTTagCompound nbt) {
        return new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockPos other = (BlockPos)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "BlockPos [" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

