/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.recipes;

import code.elix_x.excore.utils.items.ItemStackStringTranslator;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.ArrayUtils;

public class RecipeStringTranslator {
    public static String[] validateFromConfig(String ... recipe) {
        if (!RecipeStringTranslator.isEmpty(recipe = (String[])ArrayUtils.clone((Object[])recipe)) && RecipeStringTranslator.isShaped(recipe)) {
            for (int i = 0; i < RecipeStringTranslator.getDefinitionsBegining(recipe); ++i) {
                recipe[i] = recipe[i].replace('_', ' ');
            }
        }
        return recipe;
    }

    public static boolean isEmpty(String ... srecipe) {
        return ArrayUtils.isEmpty((Object[])srecipe);
    }

    public static boolean isShaped(String ... recipe) {
        return !ItemStackStringTranslator.isValidItemstackAdvanced(recipe[0]);
    }

    public static int getDefinitionsBegining(String ... recipe) {
        int i;
        for (i = 0; !(i >= recipe.length || recipe[i].length() == 1 && ItemStackStringTranslator.isValidItemstackAdvanced(recipe[i + 1])); ++i) {
        }
        return i;
    }

    public static Object[] fromString(String ... srecipe) {
        Object[] recipe = new Object[srecipe.length];
        if (RecipeStringTranslator.isShaped(srecipe)) {
            int j;
            int i = RecipeStringTranslator.getDefinitionsBegining(srecipe);
            for (j = 0; j < i; ++j) {
                recipe[j] = srecipe[j];
            }
            for (j = i; j < srecipe.length; ++j) {
                recipe[j] = srecipe[j].length() == 1 ? Character.valueOf(srecipe[j].charAt(0)) : ItemStackStringTranslator.fromStringAdvanced(srecipe[j]);
            }
        } else {
            for (int i = 0; i < srecipe.length; ++i) {
                recipe[i] = ItemStackStringTranslator.fromStringAdvanced(srecipe[i]);
            }
        }
        return recipe;
    }

    public static IRecipe fromString(ItemStack result, String ... srecipe) {
        if (RecipeStringTranslator.isEmpty(srecipe)) {
            return new IRecipe(){

                public boolean func_77569_a(InventoryCrafting inventory, World world) {
                    return false;
                }

                public int func_77570_a() {
                    return 0;
                }

                public ItemStack func_77571_b() {
                    return null;
                }

                public ItemStack func_77572_b(InventoryCrafting inventory) {
                    return null;
                }
            };
        }
        if (RecipeStringTranslator.isShaped(srecipe)) {
            return new ShapedOreRecipe(result, RecipeStringTranslator.fromString(srecipe));
        }
        return new ShapelessOreRecipe(result, RecipeStringTranslator.fromString(srecipe));
    }

    public static boolean isShaped(Map<String, ?> map, String ... recipe) {
        return !map.containsKey(recipe[0]) && !ItemStackStringTranslator.isValidItemstackAdvanced(recipe[0]);
    }

    public static int getDefinitionsBegining(Map<String, ?> map, String ... recipe) {
        int i;
        for (i = 0; i < recipe.length && (recipe[i].length() != 1 || !map.containsKey(recipe[i + 1]) && !ItemStackStringTranslator.isValidItemstackAdvanced(recipe[i + 1])); ++i) {
        }
        return i;
    }

    public static Object[] fromString(Map<String, ?> map, String ... srecipe) {
        Object[] recipe = new Object[srecipe.length];
        if (RecipeStringTranslator.isShaped(map, srecipe)) {
            int j;
            int i = RecipeStringTranslator.getDefinitionsBegining(map, srecipe);
            for (j = 0; j < i; ++j) {
                recipe[j] = srecipe[j];
            }
            for (j = i; j < srecipe.length; ++j) {
                recipe[j] = srecipe[j].length() == 1 ? Character.valueOf(srecipe[j].charAt(0)) : (map.containsKey(srecipe[j]) ? map.get(srecipe[j]) : ItemStackStringTranslator.fromStringAdvanced(srecipe[j]));
            }
        } else {
            for (int i = 0; i < srecipe.length; ++i) {
                recipe[i] = map.containsKey(srecipe[i]) ? map.get(srecipe[i]) : ItemStackStringTranslator.fromStringAdvanced(srecipe[i]);
            }
        }
        return recipe;
    }

    public static IRecipe fromString(ItemStack result, Map<String, ?> map, String ... srecipe) {
        if (RecipeStringTranslator.isEmpty(srecipe)) {
            return new IRecipe(){

                public boolean func_77569_a(InventoryCrafting inventory, World world) {
                    return false;
                }

                public int func_77570_a() {
                    return 0;
                }

                public ItemStack func_77571_b() {
                    return null;
                }

                public ItemStack func_77572_b(InventoryCrafting inventory) {
                    return null;
                }
            };
        }
        if (RecipeStringTranslator.isShaped(map, srecipe)) {
            return new ShapedOreRecipe(result, RecipeStringTranslator.fromString(map, srecipe));
        }
        return new ShapelessOreRecipe(result, RecipeStringTranslator.fromString(map, srecipe));
    }

    public static boolean isShaped(Object ... recipe) {
        return recipe[0] instanceof String;
    }

    public static String[] toString(Object ... recipe) {
        String[] srecipe = new String[recipe.length];
        if (RecipeStringTranslator.isShaped(recipe)) {
            int j;
            int i = 0;
            for (i = 0; i < recipe.length && !(recipe[i] instanceof Character); ++i) {
            }
            for (j = 0; j < i; ++j) {
                srecipe[j] = (String)recipe[j];
            }
            for (j = i; j < srecipe.length; ++j) {
                srecipe[j] = recipe[j] instanceof Character ? "" + recipe[j] : ItemStackStringTranslator.toStringAdvanced(recipe[j]);
            }
        } else {
            for (int i = 0; i < recipe.length; ++i) {
                srecipe[i] = ItemStackStringTranslator.toStringAdvanced(recipe[i]);
            }
        }
        return srecipe;
    }

    public static String[] toString(IRecipe recipe) {
        if (recipe instanceof ShapedOreRecipe) {
            return RecipeStringTranslator.toString(((ShapedOreRecipe)recipe).getInput());
        }
        if (recipe instanceof ShapelessOreRecipe) {
            return RecipeStringTranslator.toString(((ShapelessOreRecipe)recipe).getInput().toArray());
        }
        throw new IllegalArgumentException("Recipe must either be ShapedOreRecipe or ShapelessOreRecipe");
    }

    public static boolean isShaped(Map<?, String> map, Object ... recipe) {
        return recipe[0] instanceof String && !map.containsKey(recipe[0]);
    }

    public static String[] toString(Map<?, String> map, Object ... recipe) {
        String[] srecipe = new String[recipe.length];
        if (RecipeStringTranslator.isShaped(map, recipe)) {
            int j;
            int i = 0;
            for (i = 0; i < recipe.length && !(recipe[i] instanceof Character); ++i) {
            }
            for (j = 0; j < i; ++j) {
                srecipe[j] = (String)recipe[j];
            }
            for (j = i; j < srecipe.length; ++j) {
                srecipe[j] = recipe[j] instanceof Character ? "" + recipe[j] : (map.containsKey(recipe[j]) ? map.get(recipe[j]) : ItemStackStringTranslator.toStringAdvanced(recipe[j]));
            }
        } else {
            for (int i = 0; i < recipe.length; ++i) {
                srecipe[i] = map.containsKey(recipe[i]) ? map.get(recipe[i]) : ItemStackStringTranslator.toStringAdvanced(recipe[i]);
            }
        }
        return srecipe;
    }

    public static String[] toString(IRecipe recipe, Map<?, String> map) {
        if (recipe instanceof ShapedOreRecipe) {
            return RecipeStringTranslator.toString(map, ((ShapedOreRecipe)recipe).getInput());
        }
        if (recipe instanceof ShapelessOreRecipe) {
            return RecipeStringTranslator.toString(map, ((ShapelessOreRecipe)recipe).getInput().toArray());
        }
        throw new IllegalArgumentException("Recipe must either be ShapedOreRecipe or ShapelessOreRecipe");
    }
}

