/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.shape3d;

import code.elix_x.excore.utils.pos.BlockPos;
import code.elix_x.excore.utils.shape3d.AxisAlignedBox;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class Shape3D {
    protected double posX;
    protected double posY;
    protected double posZ;

    public Shape3D(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public Vec3 getPos() {
        return Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ);
    }

    public abstract AxisAlignedBox getBounds();

    public abstract Set<BlockPos> getAffectedBlocks(World var1);

    public abstract <E extends Entity> Set<E> getAffectedEntities(World var1, Class<E> var2);

    public Set<BlockPos> getAffectedBlocks(World world, Set<BlockPos> set) {
        HashSet<BlockPos> sset = new HashSet<BlockPos>();
        for (BlockPos pos : set) {
            if (!this.isInside(world, pos)) continue;
            sset.add(pos);
        }
        return sset;
    }

    public <E extends Entity> Set<E> getAffectedEntities(World world, Set<E> set, Class<E> clazz) {
        HashSet<Entity> sset = new HashSet<Entity>();
        for (Entity entity : set) {
            if (!this.intersectsWith(world, entity)) continue;
            sset.add(entity);
        }
        return sset;
    }

    public boolean isInside(World world, Vec3 vec) {
        return this.getBounds().isInside(world, vec);
    }

    public boolean isInside(World world, Shape3D shape) {
        return this.getBounds().isInside(world, shape);
    }

    public boolean intersectsWith(World world, Shape3D shape) {
        return this.getBounds().intersectsWith(world, shape);
    }

    public boolean isInside(World world, BlockPos pos) {
        return this.isInside(world, pos.toVec3());
    }

    public boolean isInside(World world, Entity entity) {
        return entity.field_70121_D != null ? this.isInside(world, new AxisAlignedBox(entity.field_70121_D)) : this.isInside(world, Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
    }

    public boolean intersectsWith(World world, Entity entity) {
        return entity.field_70121_D != null ? this.intersectsWith(world, new AxisAlignedBox(entity.field_70121_D)) : this.isInside(world, Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.posX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.posY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.posZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shape3D other = (Shape3D)obj;
        if (Double.doubleToLongBits(this.posX) != Double.doubleToLongBits(other.posX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.posY) != Double.doubleToLongBits(other.posY)) {
            return false;
        }
        return Double.doubleToLongBits(this.posZ) == Double.doubleToLongBits(other.posZ);
    }
}

