/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.shape3d;

import code.elix_x.excore.utils.pos.BlockPos;
import code.elix_x.excore.utils.shape3d.AxisAlignedBox;
import code.elix_x.excore.utils.shape3d.Shape3D;
import code.elix_x.excore.utils.vecs.Vec3Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SquareBasedPyramid
extends Shape3D {
    protected float rotYaw;
    protected float rotPitch;
    protected float rotOffsetDegree;
    protected double range;

    private SquareBasedPyramid() {
        super(0.0, 0.0, 0.0);
    }

    public SquareBasedPyramid(double posX, double posY, double posZ, float rotationYaw, float rotationPitch, float rotOffset, double range) {
        super(posX, posY, posZ);
        this.rotYaw = rotationYaw;
        this.rotPitch = rotationPitch;
        this.rotOffsetDegree = rotOffset;
        this.range = range;
    }

    @Override
    public AxisAlignedBox getBounds() {
        return new AxisAlignedBox(this.posX - this.range, this.posY - this.range, this.posZ - this.range, this.posX + this.range, this.posY + this.range, this.posZ + this.range);
    }

    public Vec3[] getMainVecs() {
        return new Vec3[]{Vec3Utils.getLookVec(this.rotYaw, this.rotPitch), Vec3Utils.getLookVec(this.rotYaw + this.rotOffsetDegree, this.rotPitch + this.rotOffsetDegree), Vec3Utils.getLookVec(this.rotYaw - this.rotOffsetDegree, this.rotPitch + this.rotOffsetDegree), Vec3Utils.getLookVec(this.rotYaw + this.rotOffsetDegree, this.rotPitch - this.rotOffsetDegree), Vec3Utils.getLookVec(this.rotYaw - this.rotOffsetDegree, this.rotPitch - this.rotOffsetDegree)};
    }

    public List<AxisAlignedBB> getMainBoxes() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        Vec3[] vecs = new Vec3[]{Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ)};
        Vec3[] vec2s = this.getMainVecs();
        boolean arrived = false;
        while (!arrived) {
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxZ = 0.0;
            for (int i = 0; i < 5; ++i) {
                Vec3 vec = vecs[i];
                Vec3 vec2 = vec2s[i];
                vec = vec.func_72441_c(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
                minX = minX == 0.0 ? vec.field_72450_a : Math.min(minX, vec.field_72450_a);
                minY = minY == 0.0 ? vec.field_72448_b : Math.min(minY, vec.field_72448_b);
                minZ = minZ == 0.0 ? vec.field_72449_c : Math.min(minZ, vec.field_72449_c);
                maxX = maxX == 0.0 ? vec.field_72450_a : Math.max(maxX, vec.field_72450_a);
                maxY = maxY == 0.0 ? vec.field_72448_b : Math.max(maxY, vec.field_72448_b);
                maxZ = maxZ == 0.0 ? vec.field_72449_c : Math.max(maxZ, vec.field_72449_c);
                vecs[i] = vec;
            }
            list.add(AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
            double dist = vecs[0].func_72438_d(Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ));
            if (!(dist >= this.range)) continue;
            arrived = true;
            break;
        }
        for (int i = 0; i < 5; ++i) {
            vecs[i] = null;
        }
        vecs = null;
        return list;
    }

    @Override
    public Set<BlockPos> getAffectedBlocks(World world) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        Vec3[] vecs = new Vec3[]{Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ)};
        Vec3[] vec2s = this.getMainVecs();
        boolean arrived = false;
        while (!arrived) {
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxZ = 0.0;
            for (int i = 0; i < 5; ++i) {
                Vec3 vec = vecs[i];
                Vec3 vec2 = vec2s[i];
                vec = vec.func_72441_c(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
                minX = minX == 0.0 ? vec.field_72450_a : Math.min(minX, vec.field_72450_a);
                minY = minY == 0.0 ? vec.field_72448_b : Math.min(minY, vec.field_72448_b);
                minZ = minZ == 0.0 ? vec.field_72449_c : Math.min(minZ, vec.field_72449_c);
                maxX = maxX == 0.0 ? vec.field_72450_a : Math.max(maxX, vec.field_72450_a);
                maxY = maxY == 0.0 ? vec.field_72448_b : Math.max(maxY, vec.field_72448_b);
                maxZ = maxZ == 0.0 ? vec.field_72449_c : Math.max(maxZ, vec.field_72449_c);
                vecs[i] = vec;
            }
            blocks.addAll(new AxisAlignedBox(minX, minY, minZ, maxX, maxY, maxZ).getAffectedBlocks(world));
            double dist = vecs[0].func_72438_d(Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ));
            if (!(dist >= this.range)) continue;
            arrived = true;
            break;
        }
        for (int i = 0; i < 5; ++i) {
            vecs[i] = null;
        }
        vecs = null;
        vec2s = null;
        return blocks;
    }

    @Override
    public <E extends Entity> Set<E> getAffectedEntities(World world, Class<E> clazz) {
        HashSet<E> entities = new HashSet<E>();
        Set<E> set = this.getBounds().getAffectedEntities(world, clazz);
        Vec3[] vecs = new Vec3[]{Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ), Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ)};
        Vec3[] vec2s = this.getMainVecs();
        boolean arrived = false;
        while (!arrived) {
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxZ = 0.0;
            for (int i = 0; i < 5; ++i) {
                Vec3 vec = vecs[i];
                Vec3 vec2 = vec2s[i];
                vec = vec.func_72441_c(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
                minX = minX == 0.0 ? vec.field_72450_a : Math.min(minX, vec.field_72450_a);
                minY = minY == 0.0 ? vec.field_72448_b : Math.min(minY, vec.field_72448_b);
                minZ = minZ == 0.0 ? vec.field_72449_c : Math.min(minZ, vec.field_72449_c);
                maxX = maxX == 0.0 ? vec.field_72450_a : Math.max(maxX, vec.field_72450_a);
                maxY = maxY == 0.0 ? vec.field_72448_b : Math.max(maxY, vec.field_72448_b);
                maxZ = maxZ == 0.0 ? vec.field_72449_c : Math.max(maxZ, vec.field_72449_c);
                vecs[i] = vec;
            }
            entities.addAll(new AxisAlignedBox(minX, minY, minZ, maxX, maxY, maxZ).getAffectedEntities(world, set, clazz));
            double dist = vecs[0].func_72438_d(Vec3.func_72443_a((double)this.posX, (double)this.posY, (double)this.posZ));
            if (!(dist >= this.range)) continue;
            arrived = true;
            break;
        }
        for (int i = 0; i < 5; ++i) {
            vecs[i] = null;
        }
        vecs = null;
        vec2s = null;
        return entities;
    }

    @Override
    public boolean isInside(World world, BlockPos pos) {
        return this.getAffectedBlocks(world).contains(pos);
    }

    @Override
    public boolean isInside(World world, Entity entity) {
        return this.getAffectedEntities(world, entity.getClass()).contains(entity);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.range);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Float.floatToIntBits(this.rotOffsetDegree);
        result = 31 * result + Float.floatToIntBits(this.rotPitch);
        result = 31 * result + Float.floatToIntBits(this.rotYaw);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SquareBasedPyramid other = (SquareBasedPyramid)obj;
        if (Double.doubleToLongBits(this.range) != Double.doubleToLongBits(other.range)) {
            return false;
        }
        if (Float.floatToIntBits(this.rotOffsetDegree) != Float.floatToIntBits(other.rotOffsetDegree)) {
            return false;
        }
        if (Float.floatToIntBits(this.rotPitch) != Float.floatToIntBits(other.rotPitch)) {
            return false;
        }
        return Float.floatToIntBits(this.rotYaw) == Float.floatToIntBits(other.rotYaw);
    }
}

