/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.machine;

import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.ForgeDirection;

public enum Face {
    Y_NEG,
    Y_POS,
    Z_NEG,
    Z_POS,
    X_NEG,
    X_POS;

    public static final Face[] VALUES;
    public static final Face[] OPPOSITES;

    public Face getOpposite() {
        return OPPOSITES[this.ordinal()];
    }

    public static Face fromEnumFacing(EnumFacing facing) {
        return VALUES[facing.ordinal()];
    }

    public static EnumFacing toEnumFacing(Face face) {
        return EnumFacing.values()[face.ordinal()];
    }

    public static Face fromForgeDirection(ForgeDirection facing) {
        return facing == ForgeDirection.UNKNOWN ? null : VALUES[facing.ordinal()];
    }

    public static ForgeDirection toForgeDirection(Face face) {
        return ForgeDirection.VALID_DIRECTIONS[face.ordinal()];
    }

    public static Face fromIntFacing(int facing) {
        return VALUES[facing];
    }

    static {
        VALUES = Face.values();
        OPPOSITES = new Face[]{Y_POS, Y_NEG, Z_POS, Z_NEG, X_POS, X_NEG};
    }
}

