/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.machine;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

public enum Port {
    LEFT,
    RIGHT,
    UP,
    DOWN;

    public static final Port[] VALUES;
    public static final Port[] OPPOSITES;
    public static final Port[] ROTATED;
    public static final Port[] CLOCKWISE;
    public static final int[] ROTATION;
    public static final Port[] HORIZONTAL;

    public Port getOpposite() {
        return OPPOSITES[this.ordinal()];
    }

    public Port rotated() {
        return ROTATED[this.ordinal()];
    }

    public Port rotated(int steps) {
        int clampedSteps = Math.abs(steps) % 4;
        int orderedSteps = steps >= 0 ? clampedSteps : 4 - clampedSteps;
        return orderedSteps > 0 ? this.rotated().rotated(orderedSteps - 1) : this;
    }

    public static Port fromEnumFacing(EnumFacing facing) {
        return HORIZONTAL[facing.ordinal()];
    }

    public static Port fromUVQuadrant(Vec3 uv) {
        double u = uv.field_72450_a - 0.5;
        double v = uv.field_72448_b - 0.5;
        if (Math.abs(u) > Math.abs(v)) {
            if (u < 0.0) {
                return LEFT;
            }
            return RIGHT;
        }
        if (v < 0.0) {
            return UP;
        }
        return DOWN;
    }

    static {
        VALUES = Port.values();
        OPPOSITES = new Port[]{RIGHT, LEFT, DOWN, UP};
        ROTATED = new Port[]{UP, DOWN, RIGHT, LEFT};
        CLOCKWISE = new Port[]{UP, RIGHT, DOWN, LEFT};
        ROTATION = new int[]{3, 1, 0, 2};
        HORIZONTAL = new Port[]{UP, UP, DOWN, UP, RIGHT, LEFT};
    }
}

