/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.prefab.client;

import li.cil.tis3d.api.util.RenderUtil;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public abstract class AbstractModuleItemRenderer
implements IItemRenderer {
    public static final String LOCATION_MODULE_MODEL = "tis3d:models/item/module.obj";
    public static final String LOCATION_MODULE_TEXTURE = "tis3d:textures/blocks/casing_module.png";
    public static final IModelCustom MODULE_MODEL = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("tis3d:models/item/module.obj"));
    protected final IModelCustom model;

    protected AbstractModuleItemRenderer(IModelCustom model) {
        this.model = model;
    }

    protected AbstractModuleItemRenderer() {
        this.model = MODULE_MODEL;
    }

    protected ResourceLocation getTextureLocation(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        return TextureMap.field_110576_c;
    }

    public abstract IIcon getOverlayIcon(IItemRenderer.ItemRenderType var1, ItemStack var2, Object ... var3);

    protected boolean shouldIgnoreLighting(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        return false;
    }

    protected void renderCasing(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderUtil.bindTexture(new ResourceLocation(LOCATION_MODULE_TEXTURE));
        this.model.renderAll();
    }

    protected void renderOverlay(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        IIcon icon;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0625f, (float)0.0625f, (float)-0.50024414f);
        GL11.glScalef((float)0.875f, (float)0.875f, (float)0.875f);
        if (this.shouldIgnoreLighting(type, item, data)) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        }
        if ((icon = this.getOverlayIcon(type, item, data)) != null) {
            RenderUtil.bindTexture(this.getTextureLocation(type, item, data));
            RenderUtil.drawQuad(icon.func_94209_e(), icon.func_94206_g(), icon.func_94212_f(), icon.func_94210_h());
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2884);
        RenderHelper.func_74518_a();
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        switch (type) {
            case ENTITY: {
                GL11.glTranslatef((float)-0.5f, (float)0.25f, (float)-0.5f);
                if (!RenderItem.field_82407_g) break;
                GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.25f);
                GL11.glScalef((float)0.8125f, (float)0.8125f, (float)0.8125f);
                break;
            }
            case INVENTORY: {
                GL11.glScalef((float)1.125f, (float)1.125f, (float)1.125f);
                break;
            }
            case EQUIPPED: {
                GL11.glRotatef((float)130.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)-1.1f, (float)-0.4f, (float)-0.2f);
            }
        }
        this.renderCasing(type, item, data);
        this.renderOverlay(type, item, data);
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
    }
}

