/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.prefab.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.TransformUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class AbstractModule
implements Module {
    private final Casing casing;
    private final Face face;

    protected AbstractModule(Casing casing, Face face) {
        this.casing = casing;
        this.face = face;
    }

    protected void cancelWrite() {
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            sendingPipe.cancelWrite();
        }
    }

    protected void cancelRead() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            receivingPipe.cancelRead();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isPlayerLookingAt() {
        MovingObjectPosition hit = Minecraft.func_71410_x().field_71476_x;
        return hit != null && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.getCasing().getPositionX() == hit.field_72311_b && this.getCasing().getPositionY() == hit.field_72312_c && this.getCasing().getPositionZ() == hit.field_72309_d && hit.field_72310_e == Face.toEnumFacing(this.getFace()).ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    protected Vec3 getPlayerLookAt() {
        MovingObjectPosition hit = Minecraft.func_71410_x().field_71476_x;
        if (hit != null && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.getCasing().getPositionX() == hit.field_72311_b && this.getCasing().getPositionY() == hit.field_72312_c && this.getCasing().getPositionZ() == hit.field_72309_d && hit.field_72310_e == Face.toEnumFacing(this.getFace()).ordinal()) {
            return Vec3.func_72443_a((double)(hit.field_72307_f.field_72450_a - (double)hit.field_72311_b), (double)(hit.field_72307_f.field_72448_b - (double)hit.field_72312_c), (double)(hit.field_72307_f.field_72449_c - (double)hit.field_72309_d));
        }
        return null;
    }

    protected Vec3 hitToUV(Vec3 hitPos) {
        return TransformUtil.hitToUV(this.getFace(), hitPos);
    }

    protected boolean isVisible() {
        int neighborZ;
        int neighborY;
        int neighborX;
        World world = this.getCasing().getCasingWorld();
        if (!world.func_72899_e(neighborX = this.getCasing().getPositionX() + Face.toEnumFacing(this.getFace()).func_82601_c(), neighborY = this.getCasing().getPositionY() + Face.toEnumFacing(this.getFace()).func_96559_d(), neighborZ = this.getCasing().getPositionZ() + Face.toEnumFacing(this.getFace()).func_82599_e())) {
            return false;
        }
        Chunk chunk = world.func_72938_d(neighborX, neighborZ);
        if (chunk == null || chunk.func_76621_g()) {
            return true;
        }
        Block neighborBlock = world.func_147439_a(neighborX, neighborY, neighborZ);
        return !neighborBlock.isSideSolid((IBlockAccess)world, neighborX, neighborY, neighborZ, Face.toForgeDirection(this.getFace().getOpposite()));
    }

    @Override
    public Casing getCasing() {
        return this.casing;
    }

    @Override
    public Face getFace() {
        return this.face;
    }

    @Override
    public void step() {
    }

    @Override
    public void onInstalled(ItemStack stack) {
    }

    @Override
    public void onUninstalled(ItemStack stack) {
    }

    @Override
    public void onEnabled() {
    }

    @Override
    public void onDisabled() {
    }

    @Override
    public void onDisposed() {
    }

    @Override
    public void onWriteComplete(Port port) {
    }

    @Override
    public boolean onActivate(EntityPlayer player, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onData(NBTTagCompound nbt) {
    }

    @Override
    public void onData(ByteBuf data) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }
}

