/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.prefab.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.Rotatable;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public abstract class AbstractModuleRotatable
extends AbstractModule
implements Rotatable {
    private Port facing = Port.UP;
    private static final String TAG_FACING = "facing";

    protected AbstractModuleRotatable(Casing casing, Face face) {
        super(casing, face);
    }

    @SideOnly(value=Side.CLIENT)
    protected void rotateForRendering() {
        int rotation = Port.ROTATION[this.facing.ordinal()];
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)(90 * rotation), (float)0.0f, (float)0.0f, (float)Face.toEnumFacing(this.getFace()).func_96559_d());
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
    }

    @Override
    protected Vec3 hitToUV(Vec3 hitPos) {
        return TransformUtil.hitToUV(this.getFace(), this.getFacing(), hitPos);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.facing = EnumUtils.readFromNBT(Port.class, TAG_FACING, nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        EnumUtils.writeToNBT(this.facing, TAG_FACING, nbt);
    }

    @Override
    public Port getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(Port facing) {
        this.facing = facing;
    }
}

