/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.item.ItemBookCode;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageBookCodeData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiBookCode
extends GuiScreen {
    private static final int GUI_WIDTH = 148;
    private static final int GUI_HEIGHT = 230;
    private static final int BUTTON_PAGE_CHANGE_PREV_X = 8;
    private static final int BUTTON_PAGE_CHANGE_NEXT_X = 116;
    private static final int BUTTON_PAGE_CHANGE_Y = 224;
    private static final int BUTTON_PAGE_DELETE_X = 66;
    private static final int BUTTON_PAGE_DELETE_Y = 224;
    private static final int CODE_POS_X = 18;
    private static final int CODE_POS_Y = 16;
    private static final int CODE_WIDTH = 120;
    private static final int CODE_MARGIN = 30;
    private static final int PAGE_NUMBER_X = 74;
    private static final int PAGE_NUMBER_Y = 212;
    private static final int COLOR_CODE = -13421773;
    private static final int COLOR_CODE_SELECTED = -1118482;
    private static final int COLOR_SELECTION = -869059687;
    private static final int ID_BUTTON_PAGE_NEXT = 1;
    private static final int ID_BUTTON_PAGE_PREV = 2;
    private static final int ID_BUTTON_PAGE_DELETE = 3;
    private ButtonChangePage buttonNextPage;
    private ButtonChangePage buttonPreviousPage;
    private ButtonDeletePage buttonDeletePage;
    private final EntityPlayer player;
    private final ItemBookCode.Data data;
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private int guiX = 0;
    private int guiY = 0;
    private int selectionStart = 0;
    private int selectionEnd = 0;
    private Optional<ParseException> compileError = Optional.empty();

    GuiBookCode(EntityPlayer player) {
        this.player = player;
        this.data = ItemBookCode.Data.loadFromStack(player.func_70694_bm());
        this.rebuildLines();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiX = (this.field_146294_l - 148) / 2;
        this.guiY = 2;
        this.buttonPreviousPage = new ButtonChangePage(2, this.guiX + 8, this.guiY + 224, PageChangeType.Previous);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonNextPage = new ButtonChangePage(1, this.guiX + 116, this.guiY + 224, PageChangeType.Next);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonDeletePage = new ButtonDeletePage(3, this.guiX + 66, this.guiY + 224);
        this.field_146292_n.add(this.buttonDeletePage);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.saveProgram();
        NBTTagCompound nbt = new NBTTagCompound();
        this.data.writeToNBT(nbt);
        Network.INSTANCE.getWrapper().sendToServer((IMessage)new MessageBookCodeData(nbt));
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!this.player.func_70089_S() || !Items.isBookCode(this.player.func_70694_bm())) {
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLoader.LOCATION_GUI_BOOK_CODE_BACKGROUND);
        this.func_73729_b(this.guiX, this.guiY, 0, 0, 148, 230);
        this.buttonPreviousPage.field_146125_m = this.data.getSelectedPage() > 0 && this.data.getPageCount() > 0;
        this.buttonNextPage.field_146125_m = this.data.getSelectedPage() < this.data.getPageCount() - 1 || this.data.getSelectedPage() == this.data.getPageCount() - 1 && this.isCurrentProgramNonEmpty();
        this.buttonDeletePage.field_146125_m = this.data.getPageCount() > 1 || this.isCurrentProgramNonEmpty();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawProgram(mouseX, mouseY);
        String pageInfo = String.format("%d/%d", this.data.getSelectedPage() + 1, this.data.getPageCount());
        this.field_146289_q.func_78276_b(pageInfo, this.guiX + 74 - this.field_146289_q.func_78256_a(pageInfo) / 2, this.guiY + 212, -13421773);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isInCodeArea(mouseX, mouseY)) {
            int line = this.cursorToLine(mouseY);
            int column = this.cursorToColumn(mouseX + 2, mouseY);
            this.selectionStart = this.selectionEnd = this.positionToIndex(line, column);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.isInCodeArea(mouseX, mouseY)) {
            int line = this.cursorToLine(mouseY);
            int column = this.cursorToColumn(mouseX + 2, mouseY);
            this.selectionEnd = this.positionToIndex(line, column);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        int line = this.indexToLine(this.getSelectionStart());
        int column = this.indexToColumn(this.getSelectionStart());
        if (keyCode == 203) {
            if (column > 0 || line > 0) {
                if (GuiBookCode.func_146272_n()) {
                    --this.selectionEnd;
                } else {
                    this.selectionStart = --this.selectionEnd;
                }
            }
        } else if (keyCode == 205) {
            if (column < this.lines.get(line).length() || line < this.lines.size() - 1) {
                if (GuiBookCode.func_146272_n()) {
                    ++this.selectionEnd;
                } else {
                    this.selectionStart = ++this.selectionEnd;
                }
            }
        } else if (keyCode == 200) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (currLine > 0) {
                int currColumn = this.indexToColumn(this.selectionEnd);
                int x = this.columnToX(currLine, currColumn) + 2;
                int prevLine = currLine - 1;
                int prevColumn = this.xToColumn(x, prevLine);
                int index = this.positionToIndex(prevLine, prevColumn);
                if (GuiBookCode.func_146272_n()) {
                    this.selectionEnd = index;
                } else {
                    this.selectionStart = this.selectionEnd = index;
                }
            }
        } else if (keyCode == 208) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (currLine < this.lines.size() - 1) {
                int currColumn = this.indexToColumn(this.selectionEnd);
                int x = this.columnToX(currLine, currColumn) + 2;
                int nextLine = currLine + 1;
                int nextColumn = this.xToColumn(x, nextLine);
                int index = this.positionToIndex(nextLine, nextColumn);
                if (GuiBookCode.func_146272_n()) {
                    this.selectionEnd = index;
                } else {
                    this.selectionStart = this.selectionEnd = index;
                }
            }
        } else if (keyCode == 199) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (GuiBookCode.func_146272_n()) {
                this.selectionEnd = this.positionToIndex(currLine, 0);
            } else {
                this.selectionStart = this.selectionEnd = this.positionToIndex(currLine, 0);
            }
        } else if (keyCode == 207) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (GuiBookCode.func_146272_n()) {
                this.selectionEnd = this.positionToIndex(currLine, this.lines.get(currLine).length());
            } else {
                this.selectionStart = this.selectionEnd = this.positionToIndex(currLine, this.lines.get(currLine).length());
            }
        } else if (keyCode == 211) {
            if (!this.deleteSelection()) {
                if (GuiBookCode.func_146272_n()) {
                    if (this.lines.size() > 1) {
                        this.lines.remove(line);
                    } else {
                        this.lines.get(0).setLength(0);
                    }
                    this.selectionStart = this.selectionEnd = this.positionToIndex(Math.min(this.lines.size() - 1, line), 0);
                } else if (column < this.lines.get(line).length()) {
                    this.lines.get(line).deleteCharAt(column);
                } else if (line < this.lines.size() - 1) {
                    StringBuilder currLine = this.lines.get(line);
                    StringBuilder nextLine = this.lines.get(line + 1);
                    if (currLine.length() + nextLine.length() < Settings.maxColumnsPerLine) {
                        currLine.append((CharSequence)nextLine);
                        this.lines.remove(line + 1);
                    }
                }
            }
            this.recompile();
        } else if (keyCode == 14) {
            if (!this.deleteSelection()) {
                if (column > 0) {
                    this.lines.get(line).deleteCharAt(column - 1);
                } else if (line > 0) {
                    StringBuilder prevLine = this.lines.get(line - 1);
                    StringBuilder currLine = this.lines.get(line);
                    if (prevLine.length() + currLine.length() < Settings.maxColumnsPerLine) {
                        prevLine.append((CharSequence)currLine);
                        this.lines.remove(line);
                    }
                }
                this.selectionStart = this.selectionEnd = Math.max(0, this.selectionEnd - 1);
            }
            this.recompile();
        } else if (keyCode == 28) {
            this.deleteSelection();
            if (this.lines.size() < 20) {
                StringBuilder oldLine = this.lines.get(line);
                StringBuilder newLine = new StringBuilder();
                if (column < oldLine.length()) {
                    newLine.append(oldLine.substring(column));
                    oldLine.setLength(column);
                }
                this.lines.add(line + 1, newLine);
                this.selectionStart = ++this.selectionEnd;
            }
            this.recompile();
        } else if (GuiBookCode.func_146271_m()) {
            if (keyCode == 30) {
                this.selectionStart = 0;
                this.selectionEnd = this.positionToIndex(Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else if (keyCode == 46) {
                GuiBookCode.func_146275_d((String)this.selectionToString());
            } else if (keyCode == 45) {
                GuiBookCode.func_146275_d((String)this.selectionToString());
                this.deleteSelection();
                this.recompile();
            } else if (keyCode == 47) {
                this.deleteSelection();
                String[] pastedLines = Constants.PATTERN_LINES.split(GuiBookCode.func_146277_j());
                if (!this.isValidPaste(pastedLines)) {
                    return;
                }
                this.lines.get(line).insert(this.indexToColumn(column), pastedLines[0].toUpperCase(Locale.US));
                this.lines.addAll(line + 1, Arrays.stream(pastedLines).skip(1L).map(l -> l.toUpperCase(Locale.US)).map(StringBuilder::new).collect(Collectors.toList()));
                this.selectionStart = this.selectionEnd += pastedLines[0].length();
                for (int i = 1; i < pastedLines.length; ++i) {
                    this.selectionStart = this.selectionEnd = this.selectionEnd + 1 + pastedLines[i].length();
                }
                this.recompile();
            }
        } else if (!Character.isISOControl(typedChar)) {
            this.deleteSelection();
            if (this.lines.get(line).length() < Settings.maxColumnsPerLine) {
                this.lines.get(line).insert(column, String.valueOf(typedChar).toUpperCase(Locale.US));
                this.selectionStart = ++this.selectionEnd;
            }
            this.recompile();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.buttonNextPage) {
            this.changePage(1);
        } else if (button == this.buttonPreviousPage) {
            this.changePage(-1);
        } else if (button == this.buttonDeletePage) {
            this.data.removePage(this.data.getSelectedPage());
            this.rebuildLines();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private int getSelectionStart() {
        return Math.min(this.selectionStart, this.selectionEnd);
    }

    private int getSelectionEnd() {
        return Math.max(this.selectionStart, this.selectionEnd);
    }

    private boolean intersectsSelection(int start, int end) {
        return start < this.getSelectionEnd() && end > this.getSelectionStart();
    }

    private String selectionToString() {
        int startLine = this.indexToLine(this.getSelectionStart());
        int endLine = this.indexToLine(this.getSelectionEnd());
        if (this.selectionStart == this.selectionEnd) {
            return this.lines.get(startLine).toString();
        }
        int startColumn = this.indexToColumn(this.getSelectionStart());
        int endColumn = this.indexToColumn(this.getSelectionEnd());
        if (startLine == endLine) {
            return this.lines.get(startLine).substring(startColumn, endColumn);
        }
        StringBuilder selection = new StringBuilder();
        selection.append(this.lines.get(startLine).subSequence(startColumn, this.lines.get(startLine).length())).append('\n');
        for (int line = startLine + 1; line < endLine; ++line) {
            selection.append(this.lines.get(line).toString()).append('\n');
        }
        selection.append(this.lines.get(endLine).subSequence(0, endColumn)).append('\n');
        return selection.toString();
    }

    private int cursorToLine(int y) {
        return Math.max(0, Math.min(Math.min(this.lines.size() - 1, 20), (y - this.guiY - 16) / this.field_146289_q.field_78288_b));
    }

    private int cursorToColumn(int x, int y) {
        return this.xToColumn(x, this.cursorToLine(y));
    }

    private int xToColumn(int x, int line) {
        int relX = Math.max(0, x - this.guiX - 18);
        return this.field_146289_q.func_78269_a(this.lines.get(line).toString(), relX).length();
    }

    private int columnToX(int line, int column) {
        return this.guiX + 18 + this.field_146289_q.func_78256_a(this.lines.get(line).substring(0, Math.min(column, this.lines.get(line).length())));
    }

    private int positionToIndex(int line, int column) {
        int index = 0;
        for (int l = 0; l < Math.min(line, this.lines.size()); ++l) {
            index += this.lines.get(l).length() + 1;
        }
        return index += Math.min(column, this.lines.get(Math.min(line, this.lines.size() - 1)).length());
    }

    private int indexToLine(int index) {
        int position = 0;
        for (int line = 0; line < this.lines.size(); ++line) {
            if ((position += this.lines.get(line).length() + 1) <= index) continue;
            return line;
        }
        return this.lines.size() - 1;
    }

    private int indexToColumn(int index) {
        int position = 0;
        for (StringBuilder line : this.lines) {
            if (position + line.length() + 1 > index) {
                return index - position;
            }
            position += line.length() + 1;
        }
        return this.lines.get(this.lines.size() - 1).length();
    }

    private boolean isInCodeArea(int mouseX, int mouseY) {
        return mouseX >= this.guiX + 18 - 30 && mouseX <= this.guiX + 18 + 120 + 30 && mouseY >= this.guiY + 16 - 30 && mouseY <= this.guiY + 16 + this.field_146289_q.field_78288_b * 20 + 30;
    }

    private boolean isCurrentProgramNonEmpty() {
        return this.lines.size() > 1 || this.lines.get(0).length() > 0;
    }

    private void recompile() {
        this.compileError = Optional.empty();
        List<String> program = this.lines.stream().map(StringBuilder::toString).collect(Collectors.toList());
        ArrayList<String> leadingCode = new ArrayList<String>();
        ArrayList<String> trailingCode = new ArrayList<String>();
        this.data.getExtendedProgram(this.data.getSelectedPage(), program, leadingCode, trailingCode);
        program.addAll(0, leadingCode);
        program.addAll(trailingCode);
        try {
            Compiler.compile(program, new MachineState());
        }
        catch (ParseException e) {
            int lineNumber = e.getLineNumber() - leadingCode.size();
            this.compileError = Optional.of(new ParseException(e.getMessage(), lineNumber, e.getStart(), e.getEnd()));
        }
    }

    private boolean deleteSelection() {
        if (this.selectionStart != this.selectionEnd) {
            int startLine = this.indexToLine(this.getSelectionStart());
            int endLine = this.indexToLine(this.getSelectionEnd());
            int startColumn = this.indexToColumn(this.getSelectionStart());
            int endColumn = this.indexToColumn(this.getSelectionEnd());
            if (startLine == endLine) {
                this.lines.get(startLine).delete(startColumn, endColumn);
            } else {
                this.lines.get(startLine).delete(startColumn, this.lines.get(startLine).length());
                this.lines.get(endLine).delete(0, endColumn);
                this.lines.get(startLine).append((CharSequence)this.lines.get(endLine));
                for (int line = endLine; line > startLine; --line) {
                    this.lines.remove(line);
                }
            }
            this.selectionStart = this.selectionEnd = this.getSelectionStart();
            return true;
        }
        return false;
    }

    private boolean isValidPaste(String[] pastedLines) {
        int selectedLine = this.indexToLine(this.selectionEnd);
        if (pastedLines.length == 0) {
            return false;
        }
        if (pastedLines.length - 1 + this.lines.size() > 20) {
            return false;
        }
        if (pastedLines[0].length() + this.lines.get(selectedLine).length() > Settings.maxColumnsPerLine) {
            return false;
        }
        for (String pastedLine : pastedLines) {
            if (pastedLine.length() <= Settings.maxColumnsPerLine) continue;
            return false;
        }
        return true;
    }

    private void changePage(int delta) {
        this.saveProgram();
        if (this.data.getSelectedPage() + delta == this.data.getPageCount()) {
            this.data.addPage();
        }
        this.data.setSelectedPage(this.data.getSelectedPage() + delta);
        this.selectionEnd = 0;
        this.selectionStart = 0;
        this.rebuildLines();
    }

    private void saveProgram() {
        this.data.setPage(this.data.getSelectedPage(), this.lines.stream().map(StringBuilder::toString).collect(Collectors.toList()));
    }

    private void rebuildLines() {
        if (this.data.getPageCount() < 1) {
            this.data.addPage();
        }
        List<String> program = this.data.getPage(this.data.getSelectedPage());
        this.lines.clear();
        program.forEach(line -> this.lines.add(new StringBuilder(line.toUpperCase(Locale.US))));
        this.recompile();
    }

    private void drawProgram(int mouseX, int mouseY) {
        int position = 0;
        for (int lineNumber = 0; lineNumber < this.lines.size(); ++lineNumber) {
            StringBuilder line = this.lines.get(lineNumber);
            int end = position + line.length();
            int offsetY = lineNumber * this.field_146289_q.field_78288_b;
            int lineX = this.guiX + 18;
            int lineY = this.guiY + 16 + offsetY;
            if (this.selectionStart != this.selectionEnd && this.intersectsSelection(position, end)) {
                int currX = lineX;
                int prefix = Math.max(0, this.getSelectionStart() - position);
                int selected = Math.min(line.length() - prefix, this.getSelectionEnd() - (position + prefix));
                String prefixText = line.substring(0, prefix);
                this.field_146289_q.func_85187_a(prefixText, currX, lineY, -13421773, false);
                String selectedText = line.substring(prefix, prefix + selected);
                int selectedWidth = this.field_146289_q.func_78256_a(selectedText);
                GuiBookCode.func_73734_a((int)((currX += this.field_146289_q.func_78256_a(prefixText)) - 1), (int)(lineY - 1), (int)(currX + selectedWidth), (int)(lineY + this.field_146289_q.field_78288_b - 1), (int)-869059687);
                this.field_146289_q.func_85187_a(selectedText, currX, lineY, -1118482, false);
                String postfixString = line.substring(prefix + selected);
                this.field_146289_q.func_85187_a(postfixString, currX += selectedWidth, lineY, -13421773, false);
            } else {
                this.field_146289_q.func_85187_a(line.toString(), lineX, lineY, -13421773, false);
            }
            position += line.length() + 1;
        }
        if (this.compileError.isPresent()) {
            int rawEndX;
            int startX;
            int localLineNumber;
            boolean isErrorOnNextPage;
            ParseException exception = this.compileError.get();
            boolean isErrorOnPreviousPage = exception.getLineNumber() < 0;
            boolean bl = isErrorOnNextPage = exception.getLineNumber() >= this.lines.size();
            if (isErrorOnPreviousPage) {
                localLineNumber = 0;
                startX = this.columnToX(localLineNumber, 0);
                rawEndX = this.columnToX(localLineNumber, Settings.maxColumnsPerLine);
            } else if (isErrorOnNextPage) {
                localLineNumber = this.lines.size() - 1;
                startX = this.columnToX(localLineNumber, 0);
                rawEndX = this.columnToX(localLineNumber, Settings.maxColumnsPerLine);
            } else {
                localLineNumber = exception.getLineNumber();
                startX = this.columnToX(localLineNumber, exception.getStart());
                rawEndX = this.columnToX(localLineNumber, exception.getEnd());
            }
            int startY = this.guiY + 16 + localLineNumber * this.field_146289_q.field_78288_b - 1;
            int endX = Math.max(rawEndX, startX + this.field_146289_q.func_78263_a(' '));
            GuiBookCode.func_73734_a((int)(startX - 1), (int)(startY + this.field_146289_q.field_78288_b - 1), (int)endX, (int)(startY + this.field_146289_q.field_78288_b), (int)-52429);
            this.drawTextCursor();
            if (mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= startY + this.field_146289_q.field_78288_b) {
                ArrayList<String> tooltip = new ArrayList<String>();
                if (isErrorOnPreviousPage) {
                    tooltip.add(I18n.func_135052_a((String)"tis3d.book_code.error_on_previous_page", (Object[])new Object[0]));
                } else if (isErrorOnNextPage) {
                    tooltip.add(I18n.func_135052_a((String)"tis3d.book_code.error_on_next_page", (Object[])new Object[0]));
                }
                tooltip.addAll(Arrays.asList(Constants.PATTERN_LINES.split(I18n.func_135052_a((String)exception.getMessage(), (Object[])new Object[0]))));
                this.func_146283_a(tooltip, mouseX, mouseY);
                GL11.glDisable((int)2896);
            }
        } else {
            this.drawTextCursor();
        }
    }

    private void drawTextCursor() {
        if (System.currentTimeMillis() % 800L <= 400L) {
            int line = this.indexToLine(this.selectionEnd);
            int column = this.indexToColumn(this.selectionEnd);
            StringBuilder sb = this.lines.get(line);
            int x = this.guiX + 18 + this.field_146289_q.func_78256_a(sb.substring(0, column)) - 1;
            int y = this.guiY + 16 + line * this.field_146289_q.field_78288_b - 1;
            GuiBookCode.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 2 + 1), (int)(y + this.field_146289_q.field_78288_b + 1), (int)-869059789);
            GuiBookCode.func_73734_a((int)x, (int)y, (int)(x + 2), (int)(y + this.field_146289_q.field_78288_b), (int)-1118482);
        }
    }

    private class ButtonDeletePage
    extends GuiButton {
        private static final int TEXTURE_X = 158;
        private static final int TEXTURE_Y = 231;
        private static final int BUTTON_WIDTH = 14;
        private static final int BUTTON_HEIGHT = 14;

        public ButtonDeletePage(int buttonId, int x, int y) {
            super(buttonId, x, y, 14, 14, "");
        }

        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (!this.field_146125_m) {
                return;
            }
            boolean isHovered = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBookCode.this.field_146297_k.func_110434_K().func_110577_a(TextureLoader.LOCATION_GUI_BOOK_CODE_BACKGROUND);
            int offsetX = isHovered ? 14 : 0;
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 158 + offsetX, 231, 14, 14);
        }
    }

    private class ButtonChangePage
    extends GuiButton {
        private static final int TEXTURE_X = 110;
        private static final int TEXTURE_Y = 231;
        private static final int BUTTON_WIDTH = 23;
        private static final int BUTTON_HEIGHT = 12;
        private final PageChangeType type;

        public ButtonChangePage(int buttonId, int x, int y, PageChangeType type) {
            super(buttonId, x, y, 23, 12, "");
            this.type = type;
        }

        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (!this.field_146125_m) {
                return;
            }
            boolean isHovered = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBookCode.this.field_146297_k.func_110434_K().func_110577_a(TextureLoader.LOCATION_GUI_BOOK_CODE_BACKGROUND);
            int offsetX = isHovered ? 23 : 0;
            int offsetY = this.type == PageChangeType.Previous ? 12 : 0;
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 110 + offsetX, 231 + offsetY, 23, 12);
        }
    }

    private static enum PageChangeType {
        Previous,
        Next;

    }
}

