/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.client.gui.GuiBookCode;
import li.cil.tis3d.client.gui.GuiManual;
import li.cil.tis3d.client.gui.GuiModuleMemory;
import li.cil.tis3d.client.gui.GuiModuleTerminal;
import li.cil.tis3d.common.gui.GuiHandlerCommon;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.module.ModuleTerminal;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public final class GuiHandlerClient
extends GuiHandlerCommon {
    @Override
    @Nullable
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (GuiHandlerCommon.GuiId.VALUES[id]) {
            case BOOK_CODE: {
                return GuiHandlerClient.getGuiBookCode(player);
            }
            case BOOK_MANUAL: {
                return new GuiManual();
            }
            case MODULE_TERMINAL: {
                return GuiHandlerClient.getGuiModuleTerminal(world);
            }
            case MODULE_MEMORY: {
                return GuiHandlerClient.getGuiModuleMemory(player);
            }
        }
        return null;
    }

    @Nullable
    private static Object getGuiBookCode(EntityPlayer player) {
        if (!Items.isBookCode(player.func_70694_bm())) {
            return null;
        }
        return new GuiBookCode(player);
    }

    @Nullable
    private static Object getGuiModuleTerminal(World world) {
        MovingObjectPosition hit = Minecraft.func_71410_x().field_71476_x;
        if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return null;
        }
        TileEntity tileEntity = world.func_147438_o(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
        if (!(tileEntity instanceof Casing)) {
            return null;
        }
        Casing casing = (Casing)tileEntity;
        Module module = casing.getModule(Face.fromIntFacing(hit.field_72310_e));
        if (!(module instanceof ModuleTerminal)) {
            return null;
        }
        return new GuiModuleTerminal((ModuleTerminal)module);
    }

    @Nullable
    private static Object getGuiModuleMemory(EntityPlayer player) {
        if (!Items.isModuleReadOnlyMemory(player.func_70694_bm())) {
            return null;
        }
        return new GuiModuleMemory(player);
    }
}

