/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Optional;
import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.client.manual.Document;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.common.api.ManualAPIImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiManual
extends GuiScreen {
    private static final int documentMaxWidth = 220;
    private static final int documentMaxHeight = 176;
    private static final int scrollPosX = 250;
    private static final int scrollPosY = 48;
    private static final int scrollWidth = 26;
    private static final int scrollHeight = 180;
    private static final int tabPosX = -52;
    private static final int tabPosY = 40;
    private static final int tabWidth = 64;
    private static final int tabHeight = 32;
    private static final int tabOverlap = 8;
    private static final int maxTabsPerSide = 7;
    private static final int windowWidth = 256;
    private static final int windowHeight = 256;
    private int guiLeft = 0;
    private int guiTop = 0;
    private int xSize = 0;
    private int ySize = 0;
    private boolean isDragging = false;
    private Segment document = null;
    private int documentHeight = 0;
    private Optional<InteractiveSegment> currentSegment = Optional.empty();
    private ImageButton scrollButton = null;

    public void pushPage(String path) {
        if (!ManualAPIImpl.peekPath().equals(path)) {
            ManualAPIImpl.pushPath(path);
            this.refreshPage();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution screenSize = new ScaledResolution(this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        ScaledResolution guiSize = new ScaledResolution(256, 256);
        int midX = screenSize.scaledWidth / 2;
        int midY = screenSize.scaledHeight / 2;
        this.guiLeft = midX - guiSize.scaledWidth / 2;
        this.guiTop = midY - guiSize.scaledHeight / 2;
        this.xSize = guiSize.scaledWidth;
        this.ySize = guiSize.scaledHeight;
        for (int i = 0; i < ManualAPIImpl.getTabs().size() && i < 7; ++i) {
            int x = this.guiLeft + -52;
            int y = this.guiTop + 40 + i * 24;
            this.field_146292_n.add(new ImageButton(i, x, y, 64, 23, TextureLoader.LOCATION_GUI_MANUAL_TAB).setImageHeight(32).setVerticalImageOffset(-4));
        }
        this.scrollButton = new ImageButton(-1, this.guiLeft + 250, this.guiTop + 48, 26, 13, TextureLoader.LOCATION_GUI_MANUAL_SCROLL);
        this.field_146292_n.add(this.scrollButton);
        this.refreshPage();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ImageButton button;
        ManualAPIImpl.Tab tab;
        int i;
        GL11.glEnable((int)3042);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146297_k.field_71446_o.func_110577_a(TextureLoader.LOCATION_GUI_MANUAL_BACKGROUND);
        Gui.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (float)256.0f, (float)256.0f);
        this.scrollButton.field_146124_l = this.canScroll();
        this.scrollButton.hoverOverride = this.isDragging;
        for (i = 0; i < ManualAPIImpl.getTabs().size() && i < 7; ++i) {
            tab = ManualAPIImpl.getTabs().get(i);
            button = (ImageButton)((Object)this.field_146292_n.get(i));
            GL11.glPushMatrix();
            GL11.glTranslated((double)(button.field_146128_h + 30), (double)(button.field_146129_i + 4 - 4), (double)this.field_73735_i);
            tab.renderer.render();
            GL11.glPopMatrix();
        }
        this.currentSegment = Document.render(this.document, this.guiLeft + 16, this.guiTop + 48, 220, 176, this.offset(), this.field_146289_q, mouseX, mouseY);
        if (!this.isDragging) {
            this.currentSegment.ifPresent(s -> s.tooltip().ifPresent(t -> this.drawHoveringText(Collections.singletonList(StatCollector.func_74838_a((String)t)), mouseX, mouseY, this.field_146289_q)));
            for (i = 0; i < ManualAPIImpl.getTabs().size() && i < 7; ++i) {
                tab = ManualAPIImpl.getTabs().get(i);
                button = (ImageButton)((Object)this.field_146292_n.get(i));
                if (mouseX <= button.field_146128_h || mouseX >= button.field_146128_h + button.field_146120_f || mouseY <= button.field_146129_i || mouseY >= button.field_146129_i + button.field_146121_g || tab.tooltip == null) continue;
                this.drawHoveringText(Collections.singletonList(StatCollector.func_74838_a((String)tab.tooltip)), mouseX, mouseY, this.field_146289_q);
            }
        }
        if (this.canScroll() && (this.isCoordinateOverScrollBar(mouseX - this.guiLeft, mouseY - this.guiTop) || this.isDragging)) {
            this.drawHoveringText(Collections.singletonList(100 * this.offset() / this.maxOffset() + "%"), this.guiLeft + 250 + 26, this.scrollButton.field_146129_i + this.scrollButton.field_146121_g + 1, this.field_146289_q);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (Mouse.hasWheel() && Mouse.getEventDWheel() != 0) {
            if (Math.signum(Mouse.getEventDWheel()) < 0.0f) {
                this.scrollDown();
            } else {
                this.scrollUp();
            }
        }
    }

    protected void func_73869_a(char ch, int code) {
        if (code == this.field_146297_k.field_71474_y.field_74314_A.func_151463_i()) {
            this.popPage();
        } else if (code == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(ch, code);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        if (this.canScroll() && button == 0 && this.isCoordinateOverScrollBar(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            this.isDragging = true;
            this.scrollMouse(mouseY);
        } else if (button == 0) {
            this.currentSegment.ifPresent(s -> s.onMouseClick(mouseX, mouseY));
        } else if (button == 1) {
            this.popPage();
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int lastButtonClicked, long timeSinceMouseClick) {
        super.func_146273_a(mouseX, mouseY, lastButtonClicked, timeSinceMouseClick);
        if (this.isDragging) {
            this.scrollMouse(mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        super.func_146286_b(mouseX, mouseY, button);
        if (button == 0) {
            this.isDragging = false;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k >= 0 && button.field_146127_k < ManualAPIImpl.getTabs().size()) {
            ManualAPI.navigate(ManualAPIImpl.getTabs().get((int)button.field_146127_k).path);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private boolean canScroll() {
        return this.maxOffset() > 0;
    }

    private int offset() {
        return ManualAPIImpl.peekOffset();
    }

    private int maxOffset() {
        return this.documentHeight - 176;
    }

    private void refreshPage() {
        Iterable<String> content = ManualAPI.contentFor(ManualAPIImpl.peekPath());
        this.document = Document.parse(content != null ? content : Collections.singletonList("Document not found: " + ManualAPIImpl.peekPath()));
        this.documentHeight = Document.height(this.document, 220, this.field_146289_q);
        this.scrollTo(this.offset());
    }

    private void popPage() {
        if (ManualAPIImpl.getHistorySize() > 1) {
            ManualAPIImpl.popPath();
            this.refreshPage();
        } else {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    private void scrollMouse(int mouseY) {
        this.scrollTo((int)Math.round(((double)(mouseY - this.guiTop - 48) - 6.5) * (double)this.maxOffset() / 167.0));
    }

    private void scrollUp() {
        this.scrollTo(this.offset() - Document.lineHeight(this.field_146289_q) * 3);
    }

    private void scrollDown() {
        this.scrollTo(this.offset() + Document.lineHeight(this.field_146289_q) * 3);
    }

    private void scrollTo(int row) {
        ManualAPIImpl.setOffset(Math.max(0, Math.min(this.maxOffset(), row)));
        int yMin = this.guiTop + 48;
        this.scrollButton.field_146129_i = this.maxOffset() > 0 ? yMin + 167 * this.offset() / this.maxOffset() : yMin;
    }

    private boolean isCoordinateOverScrollBar(int x, int y) {
        return x > 250 && x < 276 && y >= 48 && y < 228;
    }

    private static class ScaledResolution {
        public final int scaledWidth;
        public final int scaledHeight;

        public ScaledResolution(int width, int height) {
            int scaleFactor = 1;
            int guiScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
            if (guiScale == 0) {
                guiScale = 1000;
            }
            while (scaleFactor < guiScale && width / (scaleFactor + 1) >= 320 && height / (scaleFactor + 1) >= 240) {
                ++scaleFactor;
            }
            if (Minecraft.func_71410_x().func_152349_b() && scaleFactor % 2 != 0 && scaleFactor != 1) {
                --scaleFactor;
            }
            this.scaledWidth = MathHelper.func_76143_f((double)((double)width / (double)scaleFactor));
            this.scaledHeight = MathHelper.func_76143_f((double)((double)height / (double)scaleFactor));
        }
    }

    private static class ImageButton
    extends GuiButton {
        private final ResourceLocation image;
        private boolean hoverOverride = false;
        private int verticalImageOffset = 0;
        private int imageHeightOverride = 0;

        public ImageButton(int id, int x, int y, int w, int h, ResourceLocation image) {
            super(id, x, y, w, h, "");
            this.image = image;
        }

        public ImageButton setImageHeight(int height) {
            this.imageHeightOverride = height;
            return this;
        }

        public ImageButton setVerticalImageOffset(int offset) {
            this.verticalImageOffset = offset;
            return this;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(this.image);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int x0 = this.field_146128_h;
                int x1 = this.field_146128_h + this.field_146120_f;
                int y0 = this.field_146129_i + this.verticalImageOffset;
                int y1 = this.field_146129_i + this.verticalImageOffset + (this.imageHeightOverride > 0 ? this.imageHeightOverride : this.field_146121_g);
                double u0 = 0.0;
                double u1 = 1.0;
                double v0 = this.hoverOverride || this.func_146114_a(this.field_146123_n) == 2 ? 0.5 : 0.0;
                double v1 = v0 + 0.5;
                Tessellator t = Tessellator.field_78398_a;
                t.func_78371_b(7);
                t.func_78374_a((double)x0, (double)y1, (double)this.field_73735_i, 0.0, v1);
                t.func_78374_a((double)x1, (double)y1, (double)this.field_73735_i, 1.0, v1);
                t.func_78374_a((double)x1, (double)y0, (double)this.field_73735_i, 1.0, v0);
                t.func_78374_a((double)x0, (double)y0, (double)this.field_73735_i, 0.0, v0);
                t.func_78381_a();
            }
        }
    }
}

