/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import li.cil.tis3d.api.FontRendererAPI;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageModuleReadOnlyMemoryData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiModuleMemory
extends GuiScreen {
    private static final int GUI_WIDTH = 190;
    private static final int GUI_HEIGHT = 130;
    private static final int GRID_LEFT = 25;
    private static final int GRID_TOP = 13;
    private static final int CELL_WIDTH = 10;
    private static final int CELL_HEIGHT = 7;
    public static final String LABEL_INITIALIZING = "INITIALIZING...";
    private final EntityPlayer player;
    private final byte[] data = new byte[256];
    private int guiX = 0;
    private int guiY = 0;
    private static int selectedCell = 0;
    private boolean highNibble = true;
    private boolean receivedData;
    private long initTime;

    GuiModuleMemory(EntityPlayer player) {
        this.player = player;
    }

    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.data, 0, Math.min(data.length, this.data.length));
        this.receivedData = true;
        this.initTime = System.currentTimeMillis();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiX = (this.field_146294_l - 190) / 2;
        this.guiY = (this.field_146295_m - 130) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.receivedData) {
            Network.INSTANCE.getWrapper().sendToServer((IMessage)new MessageModuleReadOnlyMemoryData(this.data));
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!this.player.func_70089_S() || !Items.isModuleReadOnlyMemory(this.player.func_70694_bm())) {
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLoader.LOCATION_GUI_MEMORY);
        this.func_73729_b(this.guiX, this.guiY, 0, 0, 190, 130);
        this.drawHeaders();
        this.drawInitializing();
        if (!this.receivedData) {
            return;
        }
        this.drawMemory();
        this.drawSelectionBox();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.selectCellAt(mouseX, mouseY);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.selectCellAt(mouseX, mouseY);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        if (!this.receivedData) {
            return;
        }
        int digit = Character.digit(typedChar, 16);
        if (digit >= 0) {
            if (this.highNibble) {
                byte value = this.data[selectedCell];
                value = (byte)(value & 0xF);
                this.data[GuiModuleMemory.selectedCell] = value = (byte)(value | (digit & 0xF) << 4);
            } else {
                byte value = this.data[selectedCell];
                value = (byte)(value & 0xF0);
                this.data[GuiModuleMemory.selectedCell] = value = (byte)(value | digit & 0xF);
            }
            boolean bl = this.highNibble = !this.highNibble;
            if (this.highNibble) {
                selectedCell = (selectedCell + 1) % this.data.length;
            }
        } else if (keyCode == 211) {
            this.data[GuiModuleMemory.selectedCell] = 0;
            this.highNibble = true;
        } else if (keyCode == 14) {
            if (this.highNibble) {
                selectedCell = (selectedCell - 1 + this.data.length) % this.data.length;
            }
            this.data[GuiModuleMemory.selectedCell] = 0;
            this.highNibble = true;
        } else {
            int col = selectedCell & 0xF;
            int row = (selectedCell & 0xF0) >> 4;
            switch (keyCode) {
                case 35: 
                case 203: {
                    if (col == 0) {
                        col = 15;
                        row = (row - 1 + 16) % 16;
                        break;
                    }
                    --col;
                    break;
                }
                case 38: 
                case 205: {
                    if (col == 15) {
                        col = 0;
                        row = (row + 1) % 16;
                        break;
                    }
                    ++col;
                    break;
                }
                case 37: 
                case 200: {
                    row = (row - 1 + 16) % 16;
                    break;
                }
                case 36: 
                case 208: {
                    row = (row + 1) % 16;
                    break;
                }
                default: {
                    return;
                }
            }
            selectedCell = row << 4 | col;
            this.highNibble = true;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void selectCellAt(int mouseX, int mouseY) {
        if (!this.receivedData) {
            return;
        }
        int col = (mouseX + 1 - this.guiX - 25) / 10;
        int row = (mouseY + 1 - this.guiY - 13) / 7;
        if (this.isInGridArea(col, row)) {
            selectedCell = row << 4 | col;
            this.highNibble = true;
        }
    }

    private boolean isInGridArea(int col, int row) {
        return col >= 0 && row >= 0 && col <= 15 && row <= 15;
    }

    private void drawHeaders() {
        GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.guiX + 25 + 3), (float)(this.guiY + 6), (float)0.0f);
        for (int col = 0; col < 16; ++col) {
            FontRendererAPI.drawString(String.format("%X", col));
            GL11.glTranslatef((float)10.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.guiX + 7), (float)(this.guiY + 14), (float)0.0f);
        for (int row = 0; row < 16; ++row) {
            FontRendererAPI.drawString(String.format("0X%X0", row));
            GL11.glTranslatef((float)0.0f, (float)7.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    private void drawInitializing() {
        float sinceInitialized = (float)(System.currentTimeMillis() - this.initTime) / 1000.0f;
        if (this.receivedData && sinceInitialized > 0.5f) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - sinceInitialized / 0.5f));
        int labelWidth = FontRendererAPI.getCharWidth() * LABEL_INITIALIZING.length();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.guiX + 25 + 3 + 70 - labelWidth / 2), (float)(this.guiY + 13 + 1 + 49), (float)0.0f);
        FontRendererAPI.drawString(LABEL_INITIALIZING);
        GL11.glPopMatrix();
    }

    private void drawMemory() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int visibleCells = (int)(System.currentTimeMillis() - this.initTime);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.guiX + 25 + 1), (float)(this.guiY + 13 + 1), (float)0.0f);
        int count = Math.min(visibleCells, this.data.length);
        for (int i = 0; i < count; ++i) {
            FontRendererAPI.drawString(String.format("%02X", this.data[i]));
            int col = i & 0xF;
            if (col < 15) {
                GL11.glTranslatef((float)10.0f, (float)0.0f, (float)0.0f);
                continue;
            }
            GL11.glTranslatef((float)-150.0f, (float)7.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    private void drawSelectionBox() {
        int visibleCells = (int)(System.currentTimeMillis() - this.initTime) * 2;
        if (selectedCell > visibleCells) {
            return;
        }
        int col = selectedCell & 0xF;
        int row = (selectedCell & 0xF0) >> 4;
        int x = this.guiX + 25 + 10 * col - 1;
        int y = this.guiY + 13 + 7 * row - 1;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureLoader.LOCATION_GUI_MEMORY);
        int vPos = (int)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 16L) * 8;
        this.func_73729_b(0, 0, 245, vPos, 11, 8);
        GL11.glPopMatrix();
    }
}

