/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.renderer.tileentity;

import java.util.HashSet;
import java.util.Set;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import li.cil.tis3d.util.OneEightCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public final class TileEntitySpecialRendererCasing
extends TileEntitySpecialRenderer {
    private static final Set<Class<?>> BLACKLIST = new HashSet();

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTicks) {
        TileEntityCasing casing = (TileEntityCasing)tileEntity;
        double dx = x + 0.5;
        double dy = y + 0.5;
        double dz = z + 0.5;
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        RenderHelper.func_74518_a();
        for (Face face : Face.VALUES) {
            if (this.isRenderingBackFace(face, dx, dy, dz)) continue;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            this.setupMatrix(face);
            this.ensureSanity();
            if (!this.isPlayerHoldingKey() || !this.drawConfigOverlay(casing, face)) {
                this.drawModuleOverlay(casing, face, partialTicks);
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    private boolean isRenderingBackFace(Face face, double dx, double dy, double dz) {
        EnumFacing facing = Face.toEnumFacing(face.getOpposite());
        double dotProduct = (double)facing.func_82601_c() * dx + (double)facing.func_96559_d() * (dy - (double)Minecraft.func_71410_x().field_71439_g.func_70047_e()) + (double)facing.func_82599_e() * dz;
        return dotProduct < 0.0;
    }

    private void setupMatrix(Face face) {
        switch (face) {
            case Y_NEG: {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Y_POS: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case Z_NEG: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case Z_POS: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case X_NEG: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case X_POS: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glTranslated((double)0.5, (double)0.5, (double)-0.505);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    private void ensureSanity() {
        GL11.glEnable((int)3553);
        RenderUtil.bindTexture(TextureMap.field_110575_b);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtil.ignoreLighting();
    }

    private boolean drawConfigOverlay(TileEntityCasing casing, Face face) {
        if (!this.isPlayerKindaClose(casing)) {
            return false;
        }
        if (this.isPlayerSneaking() && !casing.isLocked()) {
            Port lookingAtPort;
            TextureAtlasSprite openSprite;
            TextureAtlasSprite closedSprite;
            boolean isLookingAt = this.isPlayerLookingAt(casing.getPositionX(), casing.getPositionY(), casing.getPositionZ(), face);
            if (isLookingAt) {
                closedSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_CLOSED);
                openSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_OPEN);
                MovingObjectPosition hit = Minecraft.func_71410_x().field_71476_x;
                Vec3 uv = TransformUtil.hitToUV(face, Vec3.func_72443_a((double)hit.field_72311_b, (double)hit.field_72312_c, (double)hit.field_72309_d).func_72444_a(hit.field_72307_f));
                lookingAtPort = Port.fromUVQuadrant(uv);
            } else {
                closedSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
                openSprite = null;
                lookingAtPort = null;
            }
            GL11.glPushMatrix();
            for (Port port : Port.CLOCKWISE) {
                TextureAtlasSprite sprite;
                boolean isClosed = casing.isReceivingPipeLocked(face, port);
                TextureAtlasSprite textureAtlasSprite = sprite = isClosed ? closedSprite : openSprite;
                if (sprite != null) {
                    RenderUtil.drawQuad(sprite);
                }
                if (port == lookingAtPort) {
                    RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_HIGHLIGHT));
                }
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            GL11.glPopMatrix();
            return isLookingAt;
        }
        TextureAtlasSprite sprite = casing.isLocked() ? RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_LOCKED) : RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_UNLOCKED);
        RenderUtil.drawQuad(sprite);
        return true;
    }

    private void drawModuleOverlay(TileEntityCasing casing, Face face, float partialTicks) {
        TextureAtlasSprite closedSprite = RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.005);
        for (Port port : Port.CLOCKWISE) {
            boolean isClosed = casing.isReceivingPipeLocked(face, port);
            if (isClosed) {
                RenderUtil.drawQuad(closedSprite);
            }
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        GL11.glPopMatrix();
        Module module = casing.getModule(face);
        if (module == null) {
            return;
        }
        if (BLACKLIST.contains(module.getClass())) {
            return;
        }
        EnumFacing facing = Face.toEnumFacing(face);
        int neighborX = casing.getPositionX() + facing.func_82601_c();
        int neighborY = casing.getPositionY() + facing.func_96559_d();
        int neighborZ = casing.getPositionZ() + facing.func_82599_e();
        int brightness = casing.func_145831_w().func_72802_i(neighborX, neighborY, neighborZ, 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(brightness % 65536), (float)(brightness / 65536));
        try {
            module.render(casing.isEnabled(), partialTicks);
        }
        catch (Exception e) {
            BLACKLIST.add(module.getClass());
            TIS3D.getLog().error("A module threw an exception while rendering, won't render again!", (Throwable)e);
        }
    }

    private boolean isPlayerKindaClose(TileEntityCasing casing) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return OneEightCompat.getDistanceSqToCenter((Entity)player, casing.field_145851_c, casing.field_145848_d, casing.field_145849_e) < 256.0;
    }

    private boolean isPlayerHoldingKey() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return Items.isKey(player.func_70694_bm());
    }

    private boolean isPlayerSneaking() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return player.func_70093_af();
    }

    private boolean isPlayerLookingAt(int x, int y, int z, Face face) {
        MovingObjectPosition hit = Minecraft.func_71410_x().field_71476_x;
        return hit != null && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && Face.fromIntFacing(hit.field_72310_e) == face && hit.field_72311_b == x && hit.field_72312_c == y && hit.field_72309_d == z;
    }
}

