/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common;

import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import li.cil.tis3d.common.Constants;
import net.minecraftforge.common.config.Configuration;

public final class Settings {
    public static int maxPacketsPerTick = 10;
    public static int maxParticlesPerTick = 5;
    public static int maxCasingsPerController = 8;
    public static int maxLinesPerProgram = 40;
    public static int maxColumnsPerLine = 18;
    public static int maxInfraredQueueLength = 16;
    public static boolean animateTypingHand = true;
    public static final Set<String> disabledModules = new HashSet<String>();
    private static final String CONFIG_VERSION = "1";
    private static final String CATEGORY_NETWORK = "network";
    private static final String CATEGORY_CONTROLLER = "controller";
    private static final String CATEGORY_MODULE = "module";
    private static final String CATEGORY_MODULE_EXECUTION = "module.execution";
    private static final String CATEGORY_MODULE_INFRARED = "module.infrared";
    private static final String CATEGORY_MODULE_TERMINAL = "module.terminal";
    private static final String NAME_ANIMATE_TYPING = "animateTyping";
    private static final String NAME_MAX_PACKETS_PER_TICK = "maxPacketsPerTick";
    private static final String NAME_MAX_PARTICLES_PER_TICK = "maxParticlesPerTick";
    private static final String NAME_MAX_CASINGS_PER_CONTROLLER = "maxCasings";
    private static final String NAME_MAX_LINES_PER_PROGRAM = "maxLinesPerProgram";
    private static final String NAME_MAX_COLUMNS_PER_LINE = "maxColumnsPerLine";
    private static final String NAME_MAX_QUEUE_LENGTH = "maxQueueLength";
    private static final String NAME_MODULE_ENABLED = "enabled";
    private static final String COMMENT_ANIMATE_TYPING = "Whether to swing the player's arm while typing on a terminal module.";
    private static final String COMMENT_MAX_PACKETS_PER_TICK = "The maximum number of status packets modules may send per tick. When this is exceeded, throttling kicks in.";
    private static final String COMMENT_MAX_PARTICLES_PER_TICK = "The maximum number of particle effects data transfer may trigger per tick. When this is exceeded, throttling kicks in.";
    private static final String COMMENT_MAX_CASINGS_PER_CONTROLLER = "The maximum number of casings a single controller supports.";
    private static final String COMMENT_MAX_LINES_PER_PROGRAM = "The maximum number of lines an ASM program for an execution node may have.";
    private static final String COMMENT_MAX_COLUMNS_PER_LINE = "The maximum number of columns per line of an ASM program for an execution node may have.";
    private static final String COMMENT_MAX_QUEUE_LENGTH = "The maximum number of infrared packets that can be stored in the receiver's buffer.";
    private static final String COMMENT_MODULE_ENABLED = "Whether the module is enabled. Disabled modules are not registered, meaning if you disable them later on the items will disappear!";

    public static void load(File configFile) {
        Configuration config = new Configuration(configFile, CONFIG_VERSION);
        config.load();
        Settings.upgradeConfig(config);
        maxPacketsPerTick = config.getInt(NAME_MAX_PACKETS_PER_TICK, CATEGORY_NETWORK, maxPacketsPerTick, 1, 500, COMMENT_MAX_PACKETS_PER_TICK);
        maxParticlesPerTick = config.getInt(NAME_MAX_PARTICLES_PER_TICK, CATEGORY_NETWORK, maxParticlesPerTick, 1, 500, COMMENT_MAX_PARTICLES_PER_TICK);
        maxCasingsPerController = config.getInt(NAME_MAX_CASINGS_PER_CONTROLLER, CATEGORY_CONTROLLER, maxCasingsPerController, 1, 512, COMMENT_MAX_CASINGS_PER_CONTROLLER);
        maxLinesPerProgram = config.getInt(NAME_MAX_LINES_PER_PROGRAM, CATEGORY_MODULE_EXECUTION, maxLinesPerProgram, 1, 200, COMMENT_MAX_LINES_PER_PROGRAM);
        maxColumnsPerLine = config.getInt(NAME_MAX_COLUMNS_PER_LINE, CATEGORY_MODULE_EXECUTION, maxColumnsPerLine, 1, 80, COMMENT_MAX_COLUMNS_PER_LINE);
        maxInfraredQueueLength = config.getInt(NAME_MAX_QUEUE_LENGTH, CATEGORY_MODULE_INFRARED, maxInfraredQueueLength, 1, 64, COMMENT_MAX_QUEUE_LENGTH);
        animateTypingHand = config.getBoolean(NAME_ANIMATE_TYPING, CATEGORY_MODULE_TERMINAL, animateTypingHand, COMMENT_ANIMATE_TYPING);
        disabledModules.clear();
        int prefixLength = "module_*".length();
        for (String module : Constants.MODULES) {
            String name = String.valueOf(module.charAt(prefixLength - 1)).toLowerCase(Locale.US) + module.substring(prefixLength);
            Settings.checkModule(config, "module." + name, module);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void upgradeConfig(Configuration config) {
        int loadedVersionInt;
        String loadedVersion = config.getLoadedConfigVersion();
        try {
            loadedVersionInt = Integer.parseInt(loadedVersion);
        }
        catch (NumberFormatException e) {
            loadedVersionInt = 0;
        }
        switch (loadedVersionInt) {
            case 0: {
                config.get(CATEGORY_MODULE_EXECUTION, NAME_MAX_LINES_PER_PROGRAM, maxLinesPerProgram, COMMENT_MAX_LINES_PER_PROGRAM, 1, 200).set(40);
                for (String module : Constants.MODULES) {
                    String moduleName = module.substring("module_".length());
                    String oldModuleName = moduleName.replace("_", "");
                    config.removeCategory(config.getCategory("module._" + moduleName));
                    config.removeCategory(config.getCategory("module." + oldModuleName));
                }
                break;
            }
        }
    }

    private static void checkModule(Configuration config, String path, String name) {
        if (!config.getBoolean(NAME_MODULE_ENABLED, path, true, COMMENT_MODULE_ENABLED)) {
            disabledModules.add(name);
        }
    }

    private Settings() {
    }
}

