/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.api;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import li.cil.tis3d.api.detail.SerialAPI;
import li.cil.tis3d.api.manual.ContentProvider;
import li.cil.tis3d.api.prefab.manual.ResourceContentProvider;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.serial.SerialProtocolDocumentationReference;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public final class SerialAPIImpl
implements SerialAPI {
    public static final SerialAPIImpl INSTANCE = new SerialAPIImpl();
    private final List<SerialInterfaceProvider> providers = new ArrayList<SerialInterfaceProvider>();
    private final SerialProtocolContentProvider serialProtocolContentProvider = new SerialProtocolContentProvider();

    public ContentProvider getSerialProtocolContentProvider() {
        return this.serialProtocolContentProvider;
    }

    @Override
    public void addProvider(SerialInterfaceProvider provider) {
        if (!this.providers.contains(provider)) {
            this.providers.add(provider);
            this.serialProtocolContentProvider.addReference(provider.getDocumentationReference());
        }
    }

    @Override
    public SerialInterfaceProvider getProviderFor(World world, int x, int y, int z, EnumFacing side) {
        for (SerialInterfaceProvider provider : this.providers) {
            if (!provider.worksWith(world, x, y, z, side)) continue;
            return provider;
        }
        return null;
    }

    private SerialAPIImpl() {
    }

    private static final class SerialProtocolContentProvider
    extends ResourceContentProvider {
        private static final String LANGUAGE_KEY = "%LANGUAGE%";
        private static final Pattern PATTERN_LANGUAGE_KEY = Pattern.compile("%LANGUAGE%");
        private static final String SERIAL_PROTOCOLS_PATH = "%LANGUAGE%/serialProtocols.md";
        private static final String SERIAL_PROTOCOLS_TEMPLATE = "%LANGUAGE%/template/serialProtocols.md";
        private static final Pattern PATTERN_LIST = Pattern.compile("@PROTOCOLS@");
        private static final Pattern PATTERN_LINE_END = Pattern.compile("\r?\n");
        private final List<SerialProtocolDocumentationReference> protocols = new ArrayList<SerialProtocolDocumentationReference>();
        private Optional<String> cachedList = Optional.empty();

        public SerialProtocolContentProvider() {
            super("tis3d", "doc/");
        }

        public void addReference(SerialProtocolDocumentationReference reference) {
            if (reference != null && !this.protocols.contains(reference)) {
                this.protocols.add(reference);
                this.cachedList = Optional.empty();
            }
        }

        @Override
        public Iterable<String> getContent(String path) {
            String language = FMLCommonHandler.instance().getCurrentLanguage();
            String localizedProtocolsPath = PATTERN_LANGUAGE_KEY.matcher(SERIAL_PROTOCOLS_PATH).replaceAll(language);
            if (localizedProtocolsPath.equals(path)) {
                String localizedTemplatePath = PATTERN_LANGUAGE_KEY.matcher(SERIAL_PROTOCOLS_TEMPLATE).replaceAll(language);
                return this.populateTemplate(super.getContent(localizedTemplatePath));
            }
            return null;
        }

        private Iterable<String> populateTemplate(Iterable<String> template) {
            if (template == null) {
                return null;
            }
            return StreamSupport.stream(template.spliterator(), false).flatMap(line -> Arrays.stream(PATTERN_LINE_END.split(PATTERN_LIST.matcher((CharSequence)line).replaceAll(this.compileLinkList())))).collect(Collectors.toList());
        }

        private String compileLinkList() {
            if (!this.cachedList.isPresent()) {
                StringBuilder sb = new StringBuilder();
                this.protocols.sort(Comparator.comparing(s -> s.name));
                for (SerialProtocolDocumentationReference protocol : this.protocols) {
                    sb.append("- [").append(StatCollector.func_74838_a((String)protocol.name)).append("](").append(protocol.link).append(")\n");
                }
                this.cachedList = Optional.of(sb.toString());
            }
            assert (this.cachedList.isPresent());
            return this.cachedList.get();
        }
    }
}

