/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block;

import li.cil.tis3d.api.ManualAPI;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.item.ItemBookManual;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import li.cil.tis3d.util.InventoryUtils;
import li.cil.tis3d.util.OneEightCompat;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockCasing
extends Block {
    public BlockCasing() {
        super(Material.field_151573_f);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntityCasing casing;
        ItemStack stack;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityCasing && (stack = (casing = (TileEntityCasing)tileEntity).func_70301_a(target.field_72310_e)) != null) {
            return stack.func_77946_l();
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return TIS3D.proxy.getCasingRenderId();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityCasing();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.func_72899_e(x, y, z)) {
            EnumFacing facing = EnumFacing.func_82600_a((int)side);
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof TileEntityCasing) {
                ItemStack moduleStack;
                TileEntityCasing casing = (TileEntityCasing)tileEntity;
                ItemStack heldItem = player.func_70694_bm();
                if (Items.isKey(heldItem)) {
                    if (!world.field_72995_K) {
                        if (casing.isLocked()) {
                            casing.unlock(heldItem);
                        } else if (!player.func_70093_af()) {
                            casing.lock(heldItem);
                        } else {
                            Vec3 uv;
                            Port port;
                            Face face;
                            casing.setReceivingPipeLocked(face, port, !casing.isReceivingPipeLocked(face = Face.fromIntFacing(side), port = Port.fromUVQuadrant(uv = TransformUtil.hitToUV(face, Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ)))));
                        }
                    }
                    return true;
                }
                if (Items.isBookManual(heldItem) && ItemBookManual.tryOpenManual(world, player, ManualAPI.pathFor(moduleStack = casing.func_70301_a(side)))) {
                    return true;
                }
                Module module = casing.getModule(Face.fromEnumFacing(facing));
                if (module != null && module.onActivate(player, hitX, hitY, hitZ)) {
                    return true;
                }
                if (casing.isLocked()) {
                    return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
                }
                ItemStack oldModule = casing.func_70301_a(side);
                if (oldModule != null) {
                    EntityItem entity;
                    if (!world.field_72995_K && (entity = InventoryUtils.drop(world, x, y, z, casing, side, 1, facing)) != null) {
                        entity.field_145804_b = 0;
                        entity.func_70100_b_(player);
                        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.2f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
                    }
                    return true;
                }
                if (heldItem != null && casing.func_102007_a(side, heldItem, side)) {
                    if (!world.field_72995_K) {
                        ItemStack insertedStack = player.field_71075_bZ.field_75098_d ? heldItem.func_77946_l().func_77979_a(1) : heldItem.func_77979_a(1);
                        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                            Port orientation = Port.fromEnumFacing(OneEightCompat.getHorizontalFacing((Entity)player));
                            casing.setInventorySlotContents(side, insertedStack, orientation);
                        } else {
                            casing.func_70299_a(side, insertedStack);
                        }
                        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.2f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
                    }
                    return true;
                }
            }
        }
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity instanceof TileEntityCasing) {
            OneEightCompat.dropInventoryItems(world, x, y, z, (TileEntityCasing)tileentity);
            world.func_147453_f(x, y, z, (Block)this);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return OneEightCompat.calcRedstone(world.func_147438_o(x, y, z));
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityCasing casing;
        Module module;
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity instanceof TileEntityCasing && (module = (casing = (TileEntityCasing)tileentity).getModule(Face.fromEnumFacing(EnumFacing.func_82600_a((int)side)).getOpposite())) instanceof Redstone) {
            return ((Redstone)module).getRedstoneOutput();
        }
        return super.func_149709_b(world, x, y, z, side);
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityCasing) {
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            casing.checkNeighbors();
            casing.notifyModulesOfBlockChange(neighborBlock);
            casing.markRedstoneDirty();
        }
        super.func_149695_a(world, x, y, z, neighborBlock);
    }
}

