/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.entity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.common.event.TickHandlerInfraredPacket;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageParticleEffect;
import li.cil.tis3d.util.Raytracing;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public final class EntityInfraredPacket
extends Entity
implements InfraredPacket {
    private static final float TRAVEL_SPEED = 24.0f;
    private static final int DEFAULT_LIFETIME = 2;
    private static final String TAG_VALUE = "value";
    private static final String TAG_LIFETIME = "lifetime";
    private static final int DATA_VALUE = 5;
    private int lifetime;
    private short value;

    public EntityInfraredPacket(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.25f, 0.25f);
    }

    public void configure(Vec3 start, Vec3 direction, short value) {
        this.func_70107_b(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        this.field_70159_w = direction.field_72450_a * 24.0;
        this.field_70181_x = direction.field_72448_b * 24.0;
        this.field_70179_y = direction.field_72449_c * 24.0;
        this.lifetime = 3;
        this.value = value;
        this.field_70180_af.func_75692_b(5, (Object)value);
    }

    public void updateLifetime() {
        if (this.lifetime-- < 1) {
            this.func_70106_y();
        }
    }

    private void revive() {
        this.field_70128_L = false;
        if (!this.field_70170_p.field_72995_K) {
            TickHandlerInfraredPacket.INSTANCE.watchPacket(this);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(5, (Object)0);
        if (!this.field_70170_p.field_72995_K) {
            TickHandlerInfraredPacket.INSTANCE.watchPacket(this);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            TickHandlerInfraredPacket.INSTANCE.unwatchPacket(this);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.lifetime = nbt.func_74762_e(TAG_LIFETIME);
        this.value = nbt.func_74765_d(TAG_VALUE);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a(TAG_LIFETIME, this.lifetime);
        nbt.func_74777_a(TAG_VALUE, this.value);
    }

    public void func_70030_z() {
        if (this.lifetime < 1) {
            this.func_70106_y();
            return;
        }
        super.func_70030_z();
        MovingObjectPosition hit = this.checkCollisions();
        this.emitParticles(hit);
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public ItemStack getPickedResult(MovingObjectPosition hit) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    @Override
    public short getPacketValue() {
        return this.value;
    }

    @Override
    public Vec3 getPacketPosition() {
        return Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
    }

    @Override
    public Vec3 getPacketDirection() {
        return Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72432_b();
    }

    @Override
    public void redirectPacket(Vec3 position, Vec3 direction, int addedLifetime) {
        this.lifetime += addedLifetime;
        if (this.lifetime > 0) {
            this.revive();
            Vec3 oldPos = this.getPacketPosition();
            Vec3 delta = position.func_72444_a(oldPos);
            double sqrDelta = delta.func_72430_b(delta);
            if (sqrDelta > 576.0) {
                double normalizer = 576.0 / sqrDelta;
                this.field_70165_t = position.field_72450_a * normalizer;
                this.field_70163_u = position.field_72448_b * normalizer;
                this.field_70161_v = position.field_72449_c * normalizer;
            } else {
                this.field_70165_t = position.field_72450_a;
                this.field_70163_u = position.field_72448_b;
                this.field_70161_v = position.field_72449_c;
            }
            Vec3 motionVec = direction.func_72432_b();
            this.field_70159_w = motionVec.field_72450_a * 24.0;
            this.field_70181_x = motionVec.field_72448_b * 24.0;
            this.field_70179_y = motionVec.field_72449_c * 24.0;
        }
    }

    private void emitParticles(MovingObjectPosition hit) {
        double dz;
        double dy;
        double dx;
        World world = this.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        double t = this.field_70146_Z.nextDouble();
        if (hit == null || hit.field_72307_f == null) {
            dx = this.field_70159_w;
            dy = this.field_70181_x;
            dz = this.field_70179_y;
        } else {
            dx = hit.field_72307_f.field_72450_a - this.field_70165_t;
            dy = hit.field_72307_f.field_72448_b - this.field_70163_u;
            dz = hit.field_72307_f.field_72449_c - this.field_70161_v;
        }
        double x = this.field_70165_t + dx * t;
        double y = this.field_70163_u + dy * t;
        double z = this.field_70161_v + dz * t;
        MessageParticleEffect message = new MessageParticleEffect(world, "reddust", x, y, z);
        NetworkRegistry.TargetPoint target = Network.getTargetPoint(world, x, y, z, 16);
        Network.INSTANCE.getWrapper().sendToAllAround((IMessage)message, target);
    }

    private MovingObjectPosition checkCollisions() {
        MovingObjectPosition hit = this.checkCollision();
        if (hit != null) {
            Vec3 oldPos = this.getPacketPosition();
            switch (hit.field_72313_a) {
                case BLOCK: {
                    this.onBlockCollision(hit);
                    break;
                }
                case ENTITY: {
                    this.onEntityCollision(hit);
                    break;
                }
                default: {
                    return null;
                }
            }
            Vec3 newPos = this.getPacketPosition();
            double delta = newPos.func_72444_a(oldPos).func_72433_c() / 24.0;
            this.field_70165_t -= this.field_70159_w * delta;
            this.field_70163_u -= this.field_70181_x * delta;
            this.field_70161_v -= this.field_70179_y * delta;
        }
        return hit;
    }

    private MovingObjectPosition checkCollision() {
        World world = this.field_70170_p;
        Vec3 start = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 target = start.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        MovingObjectPosition blockHit = Raytracing.raytrace(world, start, target, Raytracing::intersectIgnoringTransparent);
        MovingObjectPosition entityHit = this.checkEntityCollision(world, start, target);
        if (blockHit != null && blockHit.field_72313_a != MovingObjectPosition.MovingObjectType.MISS && entityHit != null && entityHit.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
            if (blockHit.field_72307_f.func_72436_e(start) < entityHit.field_72307_f.func_72436_e(start)) {
                return blockHit;
            }
            return entityHit;
        }
        if (blockHit != null) {
            return blockHit;
        }
        if (entityHit != null) {
            return entityHit;
        }
        return null;
    }

    private MovingObjectPosition checkEntityCollision(World world, Vec3 start, Vec3 target) {
        MovingObjectPosition entityHit = null;
        double bestSqrDistance = Double.POSITIVE_INFINITY;
        List collisions = world.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y));
        for (Object collision : collisions) {
            double sqrDistance;
            AxisAlignedBB entityBounds;
            MovingObjectPosition hit;
            Entity entity = (Entity)collision;
            if (!entity.func_70067_L() || (hit = (entityBounds = entity.field_70121_D).func_72327_a(start, target)) == null || !((sqrDistance = start.func_72436_e(hit.field_72307_f)) < bestSqrDistance)) continue;
            hit.field_72308_g = entity;
            hit.field_72313_a = MovingObjectPosition.MovingObjectType.ENTITY;
            entityHit = hit;
            bestSqrDistance = sqrDistance;
        }
        return entityHit;
    }

    private void onBlockCollision(MovingObjectPosition hit) {
        TileEntity tileEntity;
        World world = this.field_70170_p;
        int posX = hit.field_72311_b;
        int posY = hit.field_72312_c;
        int posZ = hit.field_72309_d;
        if (!world.func_72899_e(posX, posY, posZ)) {
            return;
        }
        Block block = world.func_147439_a(posX, posY, posZ);
        if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && block == Blocks.field_150427_aO) {
            this.func_70063_aa();
            return;
        }
        this.func_70106_y();
        if (block instanceof InfraredReceiver) {
            ((InfraredReceiver)block).onInfraredPacket(this, hit);
        }
        if ((tileEntity = world.func_147438_o(posX, posY, posZ)) instanceof InfraredReceiver) {
            ((InfraredReceiver)tileEntity).onInfraredPacket(this, hit);
        }
    }

    private void onEntityCollision(MovingObjectPosition hit) {
        this.func_70106_y();
        Entity entity = hit.field_72308_g;
        if (entity instanceof InfraredReceiver) {
            ((InfraredReceiver)entity).onInfraredPacket(this, hit);
        }
    }
}

