/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.init;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.ProxyCommon;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.item.ItemBookCode;
import li.cil.tis3d.common.item.ItemBookManual;
import li.cil.tis3d.common.item.ItemKey;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class Items {
    private static final Map<String, Item> modules = new HashMap<String, Item>();
    public static Item bookCode;
    public static Item bookManual;
    public static Item key;
    public static Item keyCreative;
    public static Item prism;

    public static Map<String, Item> getModules() {
        return modules;
    }

    public static boolean isItem(ItemStack stack, Item item) {
        return stack != null && stack.func_77973_b() == item;
    }

    public static boolean isBookCode(ItemStack stack) {
        return Items.isItem(stack, bookCode);
    }

    public static boolean isBookManual(ItemStack stack) {
        return Items.isItem(stack, bookManual);
    }

    public static boolean isKey(ItemStack stack) {
        return Items.isItem(stack, key) || Items.isKeyCreative(stack);
    }

    public static boolean isKeyCreative(ItemStack stack) {
        return Items.isItem(stack, keyCreative);
    }

    public static boolean isModuleReadOnlyMemory(ItemStack stack) {
        return Items.isItem(stack, modules.get("moduleReadOnlyMemory"));
    }

    public static void register(ProxyCommon proxy) {
        for (String module : Constants.MODULES) {
            modules.put(module, proxy.registerModule(module));
        }
        bookCode = proxy.registerItem("bookCode", ItemBookCode::new);
        bookManual = proxy.registerItem("bookManual", ItemBookManual::new);
        key = proxy.registerItem("key", ItemKey::new).func_77625_d(1);
        keyCreative = proxy.registerItem("keyCreative", ItemKey::new).func_77625_d(1);
        prism = proxy.registerItem("prism", Item::new);
    }

    public static void addRecipes() {
        Items.addModuleRecipe("moduleAudio", Item.func_150898_a((Block)Blocks.field_150323_B));
        Items.addModuleRecipe("moduleBundledRedstone", net.minecraft.init.Items.field_151132_bS);
        Items.addModuleRecipe("moduleDisplay", prism);
        Items.addModuleRecipe("moduleExecution", "ingotGold");
        Items.addModuleRecipe("moduleInfrared", net.minecraft.init.Items.field_151070_bp);
        Items.addModuleRecipe("moduleKeypad", Blocks.field_150430_aB);
        Items.addModuleRecipe("moduleRandom", net.minecraft.init.Items.field_151079_bi);
        Items.addModuleRecipe("moduleRandomAccessMemory", "gemEmerald");
        Items.addModuleRecipe("moduleReadOnlyMemory", net.minecraft.init.Items.field_151122_aG);
        Items.addModuleRecipe("moduleRedstone", net.minecraft.init.Items.field_151107_aW);
        Items.addModuleRecipe("moduleSequencer", "record");
        Items.addModuleRecipe("moduleSerialPort", "blockQuartz");
        Items.addModuleRecipe("moduleStack", Item.func_150898_a((Block)Blocks.field_150486_ae));
        Items.addModuleRecipe("moduleTimer", Item.func_150898_a((Block)Blocks.field_150354_m));
        GameRegistry.addRecipe((IRecipe)new ShapelessRecipes(new ItemStack(modules.get("moduleQueue")), Collections.singletonList(new ItemStack(modules.get("moduleStack")))));
        GameRegistry.addRecipe((IRecipe)new ShapelessRecipes(new ItemStack(modules.get("moduleStack")), Collections.singletonList(new ItemStack(modules.get("moduleQueue")))));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(key, 1), new Object[]{"GI ", "GI ", "LRQ", Character.valueOf('G'), "nuggetGold", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('Q'), "gemQuartz"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(prism, 1), new Object[]{"gemQuartz", "dustRedstone", "gemLapis", "gemEmerald"}));
    }

    private static void addModuleRecipe(String name, Object specialIngredient) {
        if (Settings.disabledModules.contains(name)) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(GameRegistry.findItem((String)"tis3d", (String)name), 2), new Object[]{"PPP", "ISI", " R ", Character.valueOf('P'), "paneGlassColorless", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), specialIngredient}));
    }

    private Items() {
    }
}

