/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.bluepower;

import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BluePowerBundledRedstoneDevice
implements IBundledDevice {
    private final BundledRedstone module;
    private final IConnectionCache<IBundledDevice> cache;

    public BluePowerBundledRedstoneDevice(BundledRedstone module) {
        this.module = module;
        this.cache = BPApi.getInstance().getRedstoneApi().createBundledConnectionCache((IBundledDevice)this);
    }

    public World getWorld() {
        return this.module.getCasing().getCasingWorld();
    }

    public int getX() {
        return this.module.getCasing().getPositionX();
    }

    public int getY() {
        return this.module.getCasing().getPositionY();
    }

    public int getZ() {
        return this.module.getCasing().getPositionZ();
    }

    public boolean canConnect(ForgeDirection face, IBundledDevice device, ConnectionType connectionType) {
        return true;
    }

    public IConnectionCache<? extends IBundledDevice> getBundledConnectionCache() {
        return this.cache;
    }

    public byte[] getBundledOutput(ForgeDirection side) {
        byte[] signal = new byte[16];
        for (int channel = 0; channel < signal.length; ++channel) {
            signal[channel] = (byte)this.module.getBundledRedstoneOutput(channel);
        }
        return signal;
    }

    public void setBundledPower(ForgeDirection face, byte[] bytes) {
        for (int channel = 0; channel < bytes.length; ++channel) {
            this.module.setBundledRedstoneInput(channel, (short)(bytes[channel] & 0xFF));
        }
    }

    public byte[] getBundledPower(ForgeDirection face) {
        byte[] signal = new byte[16];
        for (int channel = 0; channel < signal.length; ++channel) {
            signal[channel] = (byte)this.module.getBundledRedstoneInput(channel);
        }
        return signal;
    }

    public void onBundledUpdate() {
        this.module.getCasing().markDirty();
    }

    public MinecraftColor getBundledColor(ForgeDirection side) {
        return MinecraftColor.ANY;
    }

    public boolean isNormalFace(ForgeDirection side) {
        return true;
    }
}

