/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.bluepower;

import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.Redstone;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class BluePowerCallbacks {
    public static void onBundledOutputChanged(BundledRedstone module, int channel) {
        int neighborZ;
        int neighborY;
        int neighborX;
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        World world = module.getCasing().getCasingWorld();
        if (world.func_72899_e(neighborX = module.getCasing().getPositionX() + facing.func_82601_c(), neighborY = module.getCasing().getPositionY() + facing.func_96559_d(), neighborZ = module.getCasing().getPositionZ() + facing.func_82599_e())) {
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                IBundledDevice bundledDevice;
                IRedstoneDevice device = BPApi.getInstance().getRedstoneApi().getRedstoneDevice(world, neighborX, neighborY, neighborZ, face, ForgeDirection.UNKNOWN);
                if (device != null) {
                    device.onRedstoneUpdate();
                }
                if ((bundledDevice = BPApi.getInstance().getRedstoneApi().getBundledDevice(world, neighborX, neighborY, neighborZ, face, ForgeDirection.UNKNOWN)) == null) continue;
                bundledDevice.onBundledUpdate();
            }
        }
    }

    public static int getInput(Redstone module) {
        int inputZ;
        int inputY;
        int inputX;
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        World world = module.getCasing().getCasingWorld();
        if (world.func_72899_e(inputX = module.getCasing().getPositionX() + facing.func_82601_c(), inputY = module.getCasing().getPositionY() + facing.func_96559_d(), inputZ = module.getCasing().getPositionZ() + facing.func_82599_e())) {
            int maxSignal = 0;
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                int signal;
                IRedstoneDevice device = BPApi.getInstance().getRedstoneApi().getRedstoneDevice(world, inputX, inputY, inputZ, face, ForgeDirection.UNKNOWN);
                if (device == null || (signal = device.getRedstonePower(Face.toForgeDirection(module.getFace().getOpposite())) & 0xFF) <= maxSignal) continue;
                maxSignal = signal;
            }
            return maxSignal;
        }
        return 0;
    }

    public static int getBundledInput(BundledRedstone module, int channel) {
        int inputZ;
        int inputY;
        int inputX;
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        World world = module.getCasing().getCasingWorld();
        if (world.func_72899_e(inputX = module.getCasing().getPositionX() + facing.func_82601_c(), inputY = module.getCasing().getPositionY() + facing.func_96559_d(), inputZ = module.getCasing().getPositionZ() + facing.func_82599_e())) {
            int maxSignal = 0;
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                byte[] signal;
                IBundledDevice device = BPApi.getInstance().getRedstoneApi().getBundledDevice(world, inputX, inputY, inputZ, face, ForgeDirection.UNKNOWN);
                if (device == null || ((signal = device.getBundledOutput(Face.toForgeDirection(module.getFace().getOpposite())))[channel] & 0xFF) <= maxSignal) continue;
                maxSignal = signal[channel] & 0xFF;
            }
            return maxSignal;
        }
        return 0;
    }

    private BluePowerCallbacks() {
    }
}

