/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.bluepower;

import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneProvider;
import java.util.Map;
import java.util.WeakHashMap;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.integration.bluepower.BluePowerBundledRedstoneDevice;
import li.cil.tis3d.common.integration.bluepower.BluePowerRedstoneDevice;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class BluePowerProvider
implements IRedstoneProvider {
    public static final BluePowerProvider INSTANCE = new BluePowerProvider();
    private final Map<Redstone, IRedstoneDevice> redstoneDevices = new WeakHashMap<Redstone, IRedstoneDevice>();
    private final Map<BundledRedstone, IBundledDevice> bundledRedstoneDevices = new WeakHashMap<BundledRedstone, IBundledDevice>();

    public void register() {
        BPApi.getInstance().getRedstoneApi().registerRedstoneProvider((IRedstoneProvider)this);
    }

    public IRedstoneDevice getRedstoneDeviceAt(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        TileEntityCasing casing;
        Module module;
        TileEntity tileEntity;
        if (world != null && world.func_72899_e(x, y, z) && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityCasing && (module = (casing = (TileEntityCasing)tileEntity).getModule(Face.fromForgeDirection(side))) instanceof Redstone) {
            return this.redstoneDevices.computeIfAbsent((Redstone)module, BluePowerRedstoneDevice::new);
        }
        return null;
    }

    public IBundledDevice getBundledDeviceAt(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        TileEntityCasing casing;
        Module module;
        TileEntity tileEntity;
        if (world != null && world.func_72899_e(x, y, z) && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityCasing && (module = (casing = (TileEntityCasing)tileEntity).getModule(Face.fromForgeDirection(side))) instanceof BundledRedstone) {
            return this.bundledRedstoneDevices.computeIfAbsent((BundledRedstone)module, BluePowerBundledRedstoneDevice::new);
        }
        return null;
    }

    private BluePowerProvider() {
    }
}

