/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.bluepower;

import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import li.cil.tis3d.api.module.traits.Redstone;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BluePowerRedstoneDevice
implements IRedstoneDevice {
    private final Redstone module;
    private final IConnectionCache<IRedstoneDevice> cache;

    public BluePowerRedstoneDevice(Redstone module) {
        this.module = module;
        this.cache = BPApi.getInstance().getRedstoneApi().createRedstoneConnectionCache((IRedstoneDevice)this);
    }

    public World getWorld() {
        return this.module.getCasing().getCasingWorld();
    }

    public int getX() {
        return this.module.getCasing().getPositionX();
    }

    public int getY() {
        return this.module.getCasing().getPositionY();
    }

    public int getZ() {
        return this.module.getCasing().getPositionZ();
    }

    public boolean canConnect(ForgeDirection face, IRedstoneDevice device, ConnectionType connectionType) {
        return true;
    }

    public IConnectionCache<? extends IRedstoneDevice> getRedstoneConnectionCache() {
        return this.cache;
    }

    public byte getRedstonePower(ForgeDirection face) {
        return (byte)this.module.getRedstoneOutput();
    }

    public void setRedstonePower(ForgeDirection face, byte value) {
        this.module.setRedstoneInput((short)(value & 0xFF));
    }

    public void onRedstoneUpdate() {
        this.module.getCasing().markDirty();
    }

    public boolean isNormalFace(ForgeDirection face) {
        return true;
    }
}

