/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.integration.redlogic;

import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.traits.BundledRedstone;
import li.cil.tis3d.api.module.traits.Redstone;
import mods.immibis.redlogic.api.wiring.IBundledEmitter;
import mods.immibis.redlogic.api.wiring.IBundledUpdatable;
import mods.immibis.redlogic.api.wiring.IRedstoneEmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public final class RedLogicCallbacks {
    public static void onBundledOutputChanged(BundledRedstone module, int channel) {
        TileEntity tileEntity;
        int neighborZ;
        int neighborY;
        World world = module.getCasing().getCasingWorld();
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        int neighborX = module.getCasing().getPositionX() + facing.func_82601_c();
        if (world.func_72899_e(neighborX, neighborY = module.getCasing().getPositionY() + facing.func_96559_d(), neighborZ = module.getCasing().getPositionZ() + facing.func_82599_e()) && (tileEntity = world.func_147438_o(neighborX, neighborY, neighborZ)) instanceof IBundledUpdatable) {
            IBundledUpdatable updatable = (IBundledUpdatable)tileEntity;
            updatable.onBundledInputChanged();
        }
    }

    public static int getInput(Redstone module) {
        TileEntity tileEntity;
        int inputZ;
        int inputY;
        int inputX;
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        World world = module.getCasing().getCasingWorld();
        if (world.func_72899_e(inputX = module.getCasing().getPositionX() + facing.func_82601_c(), inputY = module.getCasing().getPositionY() + facing.func_96559_d(), inputZ = module.getCasing().getPositionZ() + facing.func_82599_e()) && (tileEntity = world.func_147438_o(inputX, inputY, inputZ)) instanceof IRedstoneEmitter) {
            IRedstoneEmitter emitter = (IRedstoneEmitter)tileEntity;
            int maxSignal = 0;
            for (int blockFace = 0; blockFace < 6; ++blockFace) {
                short signal = emitter.getEmittedSignalStrength(blockFace, module.getFace().getOpposite().ordinal());
                if ((signal & 0xFFFF) <= (maxSignal & 0xFFFF)) continue;
                maxSignal = (short)(signal & 0xFFFF);
            }
            return maxSignal;
        }
        return 0;
    }

    public static int getBundledInput(BundledRedstone module, int channel) {
        TileEntity tileEntity;
        int inputZ;
        int inputY;
        int inputX;
        EnumFacing facing = Face.toEnumFacing(module.getFace());
        World world = module.getCasing().getCasingWorld();
        if (world.func_72899_e(inputX = module.getCasing().getPositionX() + facing.func_82601_c(), inputY = module.getCasing().getPositionY() + facing.func_96559_d(), inputZ = module.getCasing().getPositionZ() + facing.func_82599_e()) && (tileEntity = world.func_147438_o(inputX, inputY, inputZ)) instanceof IBundledEmitter) {
            IBundledEmitter emitter = (IBundledEmitter)tileEntity;
            int maxSignal = 0;
            for (int blockFace = 0; blockFace < 6; ++blockFace) {
                byte[] signal = emitter.getBundledCableStrength(blockFace, module.getFace().getOpposite().ordinal());
                if (signal == null || (signal[channel] & 0xFF) <= maxSignal) continue;
                maxSignal = signal[channel] & 0xFF;
            }
            return maxSignal;
        }
        return 0;
    }

    private RedLogicCallbacks() {
    }
}

