/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.inventory;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import li.cil.tis3d.api.ModuleAPI;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.api.module.traits.Rotatable;
import li.cil.tis3d.common.inventory.Inventory;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageCasingInventory;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public final class InventoryCasing
extends Inventory
implements ISidedInventory {
    private final TileEntityCasing tileEntity;

    public InventoryCasing(TileEntityCasing tileEntity) {
        super("container.casing", Face.VALUES.length);
        this.tileEntity = tileEntity;
    }

    public void setInventorySlotContents(int index, ItemStack stack, Port facing) {
        if (this.items[index] == stack) {
            return;
        }
        if (this.items[index] != null) {
            this.onItemRemoved(index);
        }
        this.items[index] = stack;
        if (this.items[index] != null) {
            this.onItemAdded(index, facing);
        }
        this.func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_70296_d() {
        this.tileEntity.func_70296_d();
        if (this.tileEntity.func_145831_w() != null) {
            this.tileEntity.func_145831_w().func_147471_g(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
        }
    }

    public int[] func_94128_d(int side) {
        return new int[side];
    }

    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return side == index && this.func_70301_a(index) == null && this.tileEntity.getModule(Face.fromEnumFacing(EnumFacing.func_82600_a((int)side))) == null && this.canInstall(stack, Face.fromEnumFacing(EnumFacing.func_82600_a((int)side)));
    }

    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return side == index && stack == this.func_70301_a(index);
    }

    private boolean canInstall(ItemStack stack, Face face) {
        return ModuleAPI.getProviderFor(stack, this.tileEntity, face) != null;
    }

    @Override
    protected void onItemAdded(int index) {
        this.onItemAdded(index, Port.UP);
    }

    private void onItemAdded(int index, Port facing) {
        ItemStack stack = this.func_70301_a(index);
        if (stack == null) {
            return;
        }
        Face face = Face.VALUES[index];
        ModuleProvider provider = ModuleAPI.getProviderFor(stack, this.tileEntity, face);
        if (provider == null) {
            return;
        }
        Module module = provider.createModule(stack, this.tileEntity, face);
        if (module instanceof Rotatable) {
            ((Rotatable)module).setFacing(facing);
        }
        if (!this.tileEntity.getCasingWorld().field_72995_K) {
            NBTTagCompound moduleData;
            if (module != null) {
                module.onInstalled(stack);
                moduleData = new NBTTagCompound();
                module.writeToNBT(moduleData);
            } else {
                moduleData = null;
            }
            Network.INSTANCE.getWrapper().sendToAllAround((IMessage)new MessageCasingInventory(this.tileEntity, index, stack, moduleData), Network.getTargetPoint(this.tileEntity, 48));
        }
        this.tileEntity.setModule(Face.VALUES[index], module);
    }

    @Override
    protected void onItemRemoved(int index) {
        Face face = Face.VALUES[index];
        Module module = this.tileEntity.getModule(face);
        this.tileEntity.setModule(face, null);
        if (!this.tileEntity.getCasingWorld().field_72995_K) {
            if (module != null) {
                module.onUninstalled(this.func_70301_a(index));
                module.onDisposed();
            }
            Network.INSTANCE.getWrapper().sendToAllAround((IMessage)new MessageCasingInventory(this.tileEntity, index, null, null), Network.getTargetPoint(this.tileEntity, 48));
        }
    }
}

