/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.gui.GuiHandlerCommon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public final class ItemBookCode
extends ItemBook {
    public ItemBookCode() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        String info = StatCollector.func_74838_a((String)"tis3d.tooltip.bookCode");
        tooltip.addAll(this.getFontRenderer(stack).func_78271_c(info, 200));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            player.openGui((Object)TIS3D.instance, GuiHandlerCommon.GuiId.BOOK_CODE.ordinal(), world, 0, 0, 0);
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return world.func_147438_o(x, y, z) instanceof Casing;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public static class Data {
        private static final String CONTINUATION_MACRO = "#BWTM";
        private static final String TAG_PAGES = "pages";
        private static final String TAG_SELECTED = "selected";
        private final List<List<String>> pages = new ArrayList<List<String>>();
        private int selectedPage = 0;

        public int getSelectedPage() {
            return this.selectedPage;
        }

        public void setSelectedPage(int index) {
            this.selectedPage = index;
            this.validateSelectedPage();
        }

        public int getPageCount() {
            return this.pages.size();
        }

        public List<String> getPage(int index) {
            return Collections.unmodifiableList(this.pages.get(index));
        }

        public void addPage() {
            this.addOrSelectProgram(Collections.singletonList(""));
        }

        public void addOrSelectProgram(List<String> code) {
            if (code.isEmpty()) {
                return;
            }
            ArrayList<List<String>> newPages = new ArrayList<List<String>>();
            ArrayList<String> page = new ArrayList<String>();
            for (int i = 0; i < code.size(); ++i) {
                boolean isLastPage;
                String line = code.get(i);
                page.add(line);
                if (Objects.equals(line, CONTINUATION_MACRO)) {
                    newPages.add(new ArrayList(page));
                    page.clear();
                    continue;
                }
                if (page.size() != 20) continue;
                boolean bl = isLastPage = i + 1 == code.size();
                if (!isLastPage && !Data.isPartialProgram(page)) {
                    page.set(page.size() - 1, CONTINUATION_MACRO);
                    newPages.add(new ArrayList<String>(page));
                    page.clear();
                    page.add(line);
                    continue;
                }
                newPages.add(new ArrayList<String>(page));
                page.clear();
            }
            if (page.size() > 0) {
                newPages.add(page);
            }
            for (int startPage = 0; startPage < this.pages.size(); ++startPage) {
                if (!this.areAllPagesEqual(newPages, startPage)) continue;
                this.setSelectedPage(startPage);
                return;
            }
            this.pages.addAll(newPages);
            this.setSelectedPage(this.pages.size() - newPages.size());
        }

        public void setPage(int page, List<String> code) {
            this.pages.set(page, new ArrayList<String>(code));
        }

        public void removePage(int index) {
            this.pages.remove(index);
            this.validateSelectedPage();
        }

        public List<String> getProgram() {
            ArrayList<String> program = new ArrayList<String>(this.getPage(this.getSelectedPage()));
            ArrayList<String> leadingCode = new ArrayList<String>();
            ArrayList<String> trailingCode = new ArrayList<String>();
            this.getExtendedProgram(this.getSelectedPage(), program, leadingCode, trailingCode);
            program.addAll(0, leadingCode);
            program.addAll(trailingCode);
            return program;
        }

        public void getExtendedProgram(int page, List<String> program, List<String> leadingCode, List<String> trailingCode) {
            List<String> pageCode;
            for (int leadingPage = page - 1; leadingPage >= 0 && Data.isPartialProgram(pageCode = this.getPage(leadingPage)); --leadingPage) {
                leadingCode.addAll(0, pageCode);
            }
            if (Data.isPartialProgram(program)) {
                for (int trailingPage = page + 1; trailingPage < this.getPageCount(); ++trailingPage) {
                    pageCode = this.getPage(trailingPage);
                    trailingCode.addAll(pageCode);
                    if (!Data.isPartialProgram(pageCode)) break;
                }
            }
        }

        public static boolean isPartialProgram(List<String> program) {
            boolean continues = false;
            for (String line : program) {
                if (line.trim().isEmpty()) continue;
                continues = Objects.equals(line.trim().toUpperCase(Locale.US), CONTINUATION_MACRO);
            }
            return continues;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.pages.clear();
            NBTTagList pagesNbt = nbt.func_150295_c(TAG_PAGES, 8);
            for (int index = 0; index < pagesNbt.func_74745_c(); ++index) {
                this.pages.add(Arrays.asList(Constants.PATTERN_LINES.split(pagesNbt.func_150307_f(index))));
            }
            this.selectedPage = nbt.func_74762_e(TAG_SELECTED);
            this.validateSelectedPage();
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagList pagesNbt = new NBTTagList();
            int removed = 0;
            for (int index = 0; index < this.pages.size(); ++index) {
                List<String> program = this.pages.get(index);
                if (program.size() > 1 || program.get(0).length() > 0) {
                    pagesNbt.func_74742_a((NBTBase)new NBTTagString(String.join((CharSequence)"\n", program)));
                    continue;
                }
                if (index >= this.selectedPage) continue;
                ++removed;
            }
            nbt.func_74782_a(TAG_PAGES, (NBTBase)pagesNbt);
            nbt.func_74768_a(TAG_SELECTED, this.selectedPage - removed);
        }

        private void validateSelectedPage() {
            this.selectedPage = Math.max(0, Math.min(this.pages.size() - 1, this.selectedPage));
        }

        private boolean areAllPagesEqual(List<List<String>> newPages, int startPage) {
            for (int offset = 0; offset < newPages.size(); ++offset) {
                List<String> want;
                List<String> have = this.pages.get(startPage + offset);
                if (Objects.equals(have, want = newPages.get(offset))) continue;
                return false;
            }
            return true;
        }

        public static Data loadFromNBT(NBTTagCompound nbt) {
            Data data = new Data();
            if (nbt != null) {
                data.readFromNBT(nbt);
            }
            return data;
        }

        public static Data loadFromStack(ItemStack stack) {
            return Data.loadFromNBT(stack.func_77978_p());
        }

        public static void saveToStack(ItemStack stack, Data data) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            data.writeToNBT(nbt);
        }
    }
}

