/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageParticleEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import org.lwjgl.opengl.GL11;

public final class ModuleAudio
extends AbstractModule {
    private static final String[] INSTRUMENT_SOUND_NAMES = new String[]{"note.harp", "note.bd", "note.snare", "note.hat", "note.bassattack"};
    private long lastStep = 0L;

    public ModuleAudio(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        this.stepInput();
        this.lastStep = world.func_82737_E();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        GL11.glEnable((int)3042);
        RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_AUDIO));
        GL11.glDisable((int)3042);
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            World world;
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer() || (world = this.getCasing().getCasingWorld()).func_82737_E() <= this.lastStep) continue;
            this.playNote(receivingPipe.read());
        }
    }

    private void playNote(int value) {
        int posZ;
        int posY;
        int posX;
        int noteId = (value & 0xFF00) >>> 8;
        int volume = Math.min(4, (value & 0xF0) >>> 4);
        int instrumentId = value & 0xF;
        if (volume < 1) {
            return;
        }
        World world = this.getCasing().getCasingWorld();
        NoteBlockEvent.Play event = new NoteBlockEvent.Play(world, posX = this.getCasing().getPositionX(), posY = this.getCasing().getPositionY(), posZ = this.getCasing().getPositionZ(), world.func_72805_g(posX, posY, posZ), noteId, instrumentId);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            int note = event.getVanillaNoteId();
            float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
            String sound = INSTRUMENT_SOUND_NAMES[event.instrument.ordinal()];
            EnumFacing facing = Face.toEnumFacing(this.getFace());
            double x = (double)posX + 0.5 + (double)facing.func_82601_c() * 0.6;
            double y = (double)posY + 0.5 + (double)facing.func_96559_d() * 0.6;
            double z = (double)posZ + 0.5 + (double)facing.func_82599_e() * 0.6;
            world.func_72908_a(x, y, z, sound, (float)volume, pitch);
            MessageParticleEffect message = new MessageParticleEffect(world, "note", x, y, z);
            NetworkRegistry.TargetPoint target = Network.getTargetPoint(world, x, y, z, 16);
            Network.INSTANCE.getWrapper().sendToAllAround((IMessage)message, target);
        }
    }
}

