/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.tis3d.api.FontRendererAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.item.ItemBookCode;
import li.cil.tis3d.common.module.execution.MachineImpl;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.util.EnumUtils;
import li.cil.tis3d.util.OneEightCompat;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public final class ModuleExecution
extends AbstractModuleRotatable
implements BlockChangeAware {
    private final MachineImpl machine;
    private ParseException compileError;
    private State state = State.IDLE;
    private static final ResourceLocation[] STATE_LOCATIONS = new ResourceLocation[]{TextureLoader.LOCATION_OVERLAY_MODULE_EXECUTION_IDLE, TextureLoader.LOCATION_OVERLAY_MODULE_EXECUTION_ERROR, TextureLoader.LOCATION_OVERLAY_MODULE_EXECUTION_RUNNING, TextureLoader.LOCATION_OVERLAY_MODULE_EXECUTION_WAITING};
    private static final String TAG_STATE = "state";
    private static final String TAG_MACHINE = "machine";
    private static final String TAG_COMPILE_ERROR = "compileError";
    private static final String TAG_MESSAGE = "message";
    private static final String TAG_LINE_NUMBER = "lineNumber";
    private static final String TAG_START = "columnStart";
    private static final String TAG_END = "columnEnd";
    private static final byte DATA_TYPE_FULL = 0;
    private static final byte DATA_TYPE_INCREMENTAL = 1;
    private static final List<SourceCodeProvider> providers = new ArrayList<SourceCodeProvider>(Arrays.asList(new SourceCodeProviderVanilla(), new SourceCodeProviderBookCode()));

    public ModuleExecution(Casing casing, Face face) {
        super(casing, face);
        this.machine = new MachineImpl(this, face);
    }

    public MachineState getState() {
        return this.machine.getState();
    }

    @Override
    public void step() {
        State prevState = this.state;
        if (this.compileError != null) {
            this.state = State.ERR;
        } else if (this.getState().instructions.isEmpty()) {
            this.state = State.IDLE;
        } else {
            if (this.machine.step()) {
                this.state = State.RUN;
                this.getCasing().markDirty();
                this.sendPartialState();
                return;
            }
            this.state = State.WAIT;
        }
        if (prevState != this.state) {
            this.getCasing().markDirty();
            this.sendPartialState();
        }
    }

    @Override
    public void onEnabled() {
        this.sendFullState();
    }

    @Override
    public void onDisabled() {
        this.getState().reset();
        this.state = State.IDLE;
        this.sendPartialState();
    }

    @Override
    public void onWriteComplete(Port port) {
        if (this.compileError == null) {
            this.machine.onWriteCompleted(port);
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == Items.field_151122_aG) {
            if (!player.func_130014_f_().field_72995_K) {
                ItemStack bookCode;
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_77979_a(1);
                }
                if (player.field_71071_by.func_70441_a(bookCode = new ItemStack(li.cil.tis3d.common.init.Items.bookCode))) {
                    player.field_71069_bz.func_75142_b();
                }
                if (bookCode.field_77994_a > 0) {
                    player.func_146097_a(bookCode, false, false);
                }
            }
            return true;
        }
        if (li.cil.tis3d.common.init.Items.isBookCode(heldItem) && player.func_70093_af()) {
            ItemBookCode.Data data = ItemBookCode.Data.loadFromStack(heldItem);
            if (this.getState().code != null && this.getState().code.length > 0) {
                data.addOrSelectProgram(Arrays.asList(this.getState().code));
                ItemBookCode.Data.saveToStack(heldItem, data);
            }
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (this.getCasing().isLocked()) {
            return false;
        }
        SourceCodeProvider provider = ModuleExecution.providerFor(heldItem);
        if (provider == null) {
            return false;
        }
        Iterable<String> code = provider.codeFor(heldItem);
        if (code == null || !code.iterator().hasNext()) {
            return true;
        }
        World world = this.getCasing().getCasingWorld();
        if (!world.field_72995_K) {
            this.compile(code, player);
            this.sendFullState();
        }
        return true;
    }

    @Override
    public void onData(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public void onData(ByteBuf data) {
        MachineState machineState = this.getState();
        machineState.pc = data.readShort();
        machineState.acc = data.readShort();
        machineState.bak = data.readShort();
        machineState.last = data.readBoolean() ? Optional.of(Port.values()[data.readByte()]) : Optional.empty();
        this.state = State.values()[data.readByte()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!(enabled && this.isVisible() || this.isPlayerLookingAt())) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(STATE_LOCATIONS[this.state.ordinal()]));
        MachineState machineState = this.getState();
        if (machineState.code != null && OneEightCompat.getDistanceSqToCenter((Entity)Minecraft.func_71410_x().field_71439_g, this.getCasing().getPositionX(), this.getCasing().getPositionY(), this.getCasing().getPositionZ()) < 64.0) {
            this.renderState(machineState);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagCompound machineNbt = nbt.func_74775_l(TAG_MACHINE);
        this.getState().readFromNBT(machineNbt);
        this.state = EnumUtils.readFromNBT(State.class, TAG_STATE, nbt);
        if (nbt.func_74764_b(TAG_COMPILE_ERROR)) {
            NBTTagCompound errorNbt = nbt.func_74775_l(TAG_COMPILE_ERROR);
            this.compileError = new ParseException(errorNbt.func_74779_i(TAG_MESSAGE), errorNbt.func_74762_e(TAG_LINE_NUMBER), errorNbt.func_74762_e(TAG_START), errorNbt.func_74762_e(TAG_END));
        } else {
            this.compileError = null;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagCompound machineNbt = new NBTTagCompound();
        this.getState().writeToNBT(machineNbt);
        nbt.func_74782_a(TAG_MACHINE, (NBTBase)machineNbt);
        EnumUtils.writeToNBT(this.state, TAG_STATE, nbt);
        if (this.compileError != null) {
            NBTTagCompound errorNbt = new NBTTagCompound();
            errorNbt.func_74778_a(TAG_MESSAGE, this.compileError.getMessage());
            errorNbt.func_74768_a(TAG_LINE_NUMBER, this.compileError.getLineNumber());
            errorNbt.func_74768_a(TAG_START, this.compileError.getStart());
            errorNbt.func_74768_a(TAG_END, this.compileError.getEnd());
            nbt.func_74782_a(TAG_COMPILE_ERROR, (NBTBase)errorNbt);
        }
    }

    @Override
    public void onNeighborBlockChange(Block neighborBlock) {
        if (this.isVisible()) {
            this.sendPartialState();
        }
    }

    private void compile(Iterable<String> code, EntityPlayer player) {
        this.compileError = null;
        try {
            this.getState().clear();
            Compiler.compile(code, this.getState());
        }
        catch (ParseException e) {
            this.compileError = e;
            player.func_145747_a(new ChatComponentTranslation("tis3d.compiler.error", new Object[]{e.getLineNumber(), e.getStart(), e.getEnd()}).func_150257_a((IChatComponent)new ChatComponentTranslation(e.getMessage(), new Object[0])));
        }
    }

    private void sendFullState() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        this.getCasing().sendData(this.getFace(), nbt, (byte)0);
    }

    private void sendPartialState() {
        if (!this.isVisible()) {
            return;
        }
        ByteBuf data = Unpooled.buffer();
        data.writeShort((int)((short)this.getState().pc));
        data.writeShort((int)this.getState().acc);
        data.writeShort((int)this.getState().bak);
        data.writeBoolean(this.getState().last.isPresent());
        if (this.getState().last.isPresent()) {
            data.writeByte((int)((byte)this.getState().last.get().ordinal()));
        }
        data.writeByte(this.state.ordinal());
        this.getCasing().sendData(this.getFace(), data, (byte)1);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderState(MachineState machineState) {
        int offset;
        GL11.glTranslatef((float)0.21875f, (float)0.21875f, (float)0.0f);
        GL11.glScalef((float)0.0078125f, (float)0.0078125f, (float)1.0f);
        GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String accLast = String.format("ACC:%4X LAST:%s", machineState.acc, machineState.last.map(Enum::name).orElse("NONE"));
        FontRendererAPI.drawString(accLast);
        GL11.glTranslatef((float)0.0f, (float)(FontRendererAPI.getCharHeight() + 4), (float)0.0f);
        String bakState = String.format("BAK:%4X MODE:%s", machineState.bak, this.state.name());
        FontRendererAPI.drawString(bakState);
        GL11.glTranslatef((float)0.0f, (float)(FontRendererAPI.getCharHeight() + 4), (float)0.0f);
        ModuleExecution.drawLine(1);
        GL11.glTranslatef((float)0.0f, (float)5.0f, (float)0.0f);
        int maxLines = 50 / (FontRendererAPI.getCharHeight() + 1);
        int totalLines = machineState.code.length;
        int currentLine = machineState.lineNumbers.size() > 0 ? Optional.ofNullable(machineState.lineNumbers.get(machineState.pc)).orElse(-1) : (this.compileError != null ? this.compileError.getLineNumber() : -1);
        int page = currentLine / maxLines;
        for (int lineNumber = offset = page * maxLines; lineNumber < Math.min(totalLines, offset + maxLines); ++lineNumber) {
            String line = machineState.code[lineNumber];
            if (lineNumber == currentLine) {
                if (this.state == State.WAIT) {
                    GL11.glColor3f((float)0.66f, (float)0.66f, (float)0.66f);
                } else if (this.state == State.ERR || this.compileError != null && this.compileError.getLineNumber() == currentLine) {
                    GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
                }
                ModuleExecution.drawLine(FontRendererAPI.getCharHeight());
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            } else {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            FontRendererAPI.drawString(line, 18);
            GL11.glTranslatef((float)0.0f, (float)(FontRendererAPI.getCharHeight() + 1), (float)0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawLine(int height) {
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(-0.5, (double)((float)height + 0.5f), 0.0);
        tessellator.func_78377_a(71.5, (double)((float)height + 0.5f), 0.0);
        tessellator.func_78377_a(71.5, -0.5, 0.0);
        tessellator.func_78377_a(-0.5, -0.5, 0.0);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
    }

    private static SourceCodeProvider providerFor(ItemStack stack) {
        if (stack != null) {
            return providers.stream().filter(p -> p.worksFor(stack)).findFirst().orElse(null);
        }
        return null;
    }

    private static final class SourceCodeProviderBookCode
    implements SourceCodeProvider {
        private SourceCodeProviderBookCode() {
        }

        @Override
        public boolean worksFor(ItemStack stack) {
            return stack.func_77973_b() == li.cil.tis3d.common.init.Items.bookCode;
        }

        @Override
        public Iterable<String> codeFor(ItemStack stack) {
            ItemBookCode.Data data = ItemBookCode.Data.loadFromStack(stack);
            if (data.getPageCount() < 1) {
                return null;
            }
            return data.getProgram();
        }
    }

    private static final class SourceCodeProviderVanilla
    implements SourceCodeProvider {
        private SourceCodeProviderVanilla() {
        }

        @Override
        public boolean worksFor(ItemStack stack) {
            return stack.func_77973_b() == Items.field_151164_bB || stack.func_77973_b() == Items.field_151099_bA;
        }

        @Override
        public Iterable<String> codeFor(ItemStack stack) {
            if (!stack.func_77942_o()) {
                return null;
            }
            NBTTagCompound nbt = stack.func_77978_p();
            NBTTagList pages = nbt.func_150295_c("pages", 8);
            if (pages.func_74745_c() < 1) {
                return null;
            }
            ArrayList<String> code = new ArrayList<String>();
            for (int page = 0; page < pages.func_74745_c(); ++page) {
                Collections.addAll(code, Constants.PATTERN_LINES.split(pages.func_150307_f(page)));
            }
            return code;
        }
    }

    private static interface SourceCodeProvider {
        public boolean worksFor(ItemStack var1);

        @Nullable
        public Iterable<String> codeFor(ItemStack var1);
    }

    private static enum State {
        IDLE,
        ERR,
        RUN,
        WAIT;

    }
}

