/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Deque;
import java.util.LinkedList;
import li.cil.tis3d.api.InfraredAPI;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.common.Settings;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public final class ModuleInfrared
extends AbstractModule
implements InfraredReceiver {
    private final Deque<Short> receiveQueue = new LinkedList<Short>();
    private static final String TAG_RECEIVE_QUEUE = "receiveQueue";
    private long lastStep = 0L;

    public ModuleInfrared(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        World world = this.getCasing().getCasingWorld();
        this.stepOutput();
        this.stepInput();
        this.lastStep = world.func_82737_E();
    }

    @Override
    public void onDisabled() {
        this.receiveQueue.clear();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.receiveQueue.removeFirst();
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_INFRARED));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int[] receiveQueueNbt;
        super.readFromNBT(nbt);
        this.receiveQueue.clear();
        for (int value : receiveQueueNbt = nbt.func_74759_k(TAG_RECEIVE_QUEUE)) {
            this.receiveQueue.addLast((short)value);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        int[] receiveQueueArray = new int[this.receiveQueue.size()];
        int i = 0;
        for (short value : this.receiveQueue) {
            receiveQueueArray[i++] = value;
        }
        NBTTagIntArray receiveQueueNbt = new NBTTagIntArray(receiveQueueArray);
        nbt.func_74782_a(TAG_RECEIVE_QUEUE, (NBTBase)receiveQueueNbt);
    }

    @Override
    public void onInfraredPacket(InfraredPacket packet, MovingObjectPosition hit) {
        World world = this.getCasing().getCasingWorld();
        if (world.field_72995_K) {
            return;
        }
        short value = packet.getPacketValue();
        if (this.receiveQueue.size() < Settings.maxInfraredQueueLength) {
            this.receiveQueue.addLast(value);
        }
    }

    private void stepOutput() {
        if (this.receiveQueue.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.receiveQueue.peekFirst());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            World world;
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer() || (world = this.getCasing().getCasingWorld()).func_82737_E() <= this.lastStep) continue;
            this.emitInfraredPacket(receivingPipe.read());
        }
    }

    private void emitInfraredPacket(short value) {
        EnumFacing facing = Face.toEnumFacing(this.getFace());
        int positionX = this.getCasing().getPositionX() + facing.func_82601_c();
        int positionY = this.getCasing().getPositionY() + facing.func_96559_d();
        int positionZ = this.getCasing().getPositionZ() + facing.func_82599_e();
        World world = this.getCasing().getCasingWorld();
        Vec3 position = Vec3.func_72443_a((double)((double)positionX + 0.5), (double)((double)positionY + 0.5), (double)((double)positionZ + 0.5));
        Vec3 direction = Vec3.func_72443_a((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
        InfraredAPI.sendPacket(world, position, direction, value);
    }
}

