/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.FontRendererAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.util.OneEightCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public final class ModuleQueue
extends AbstractModuleRotatable {
    private final short[] queue = new short[17];
    private int head = 0;
    private int tail = 0;
    private static final String TAG_QUEUE = "queue";
    private static final String TAG_HEAD = "head";
    private static final String TAG_TAIL = "tail";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final int QUEUE_SIZE = 17;

    public ModuleQueue(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.tail = 0;
        this.head = 0;
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.pop();
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.head = data.readByte();
        this.tail = data.readByte();
        for (int i = 0; i < this.queue.length; ++i) {
            this.queue[i] = data.readShort();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_QUEUE));
        if (!this.isEmpty() && OneEightCompat.getDistanceSqToCenter((Entity)Minecraft.func_71410_x().field_71439_g, this.getCasing().getPositionX(), this.getCasing().getPositionY(), this.getCasing().getPositionZ()) < 64.0) {
            this.drawState();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        int[] queueNbt = nbt.func_74759_k(TAG_QUEUE);
        int count = Math.min(queueNbt.length, this.queue.length);
        for (int i = 0; i < count; ++i) {
            this.queue[i] = (short)queueNbt[i];
        }
        this.head = MathHelper.func_76125_a((int)nbt.func_74762_e(TAG_HEAD), (int)0, (int)16);
        this.tail = MathHelper.func_76125_a((int)nbt.func_74762_e(TAG_TAIL), (int)0, (int)16);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        int[] queueNbt = new int[this.queue.length];
        for (int i = 0; i < this.queue.length; ++i) {
            queueNbt[i] = this.queue[i];
        }
        nbt.func_74783_a(TAG_QUEUE, queueNbt);
        nbt.func_74768_a(TAG_HEAD, this.head);
        nbt.func_74768_a(TAG_TAIL, this.tail);
    }

    private boolean isEmpty() {
        return this.head == this.tail;
    }

    private boolean isFull() {
        return (this.head + 1) % 17 == this.tail;
    }

    private void push(short value) {
        this.queue[this.head] = value;
        this.head = (this.head + 1) % 17;
        this.sendData();
    }

    private short peek() {
        return this.queue[this.tail];
    }

    private void pop() {
        this.tail = (this.tail + 1) % 17;
        this.sendData();
    }

    private void stepOutput() {
        if (this.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.peek());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            if (this.isFull()) {
                return;
            }
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.push(receivingPipe.read());
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(this.head);
        data.writeByte(this.tail);
        for (short value : this.queue) {
            data.writeShort((int)value);
        }
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawState() {
        GL11.glTranslatef((float)0.1875f, (float)0.3125f, (float)0.0f);
        GL11.glScalef((float)0.0078125f, (float)0.0078125f, (float)1.0f);
        GL11.glTranslatef((float)4.5f, (float)14.5f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.tail;
        int j = 0;
        while (i != this.head) {
            FontRendererAPI.drawString(String.format("%4X", this.queue[i]));
            GL11.glTranslatef((float)0.0f, (float)(FontRendererAPI.getCharHeight() + 1), (float)0.0f);
            if ((j + 1) % 4 == 0) {
                GL11.glTranslatef((float)((FontRendererAPI.getCharWidth() + 1) * 5), (float)((FontRendererAPI.getCharHeight() + 1) * -4), (float)0.0f);
            }
            i = (i + 1) % 17;
            ++j;
        }
    }
}

