/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.item.ItemModuleReadOnlyMemory;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class ModuleRandomAccessMemory
extends AbstractModuleRotatable {
    protected final byte[] memory = new byte[256];
    protected byte address;
    protected State state = State.ADDRESS;
    public static final int MEMORY_SIZE = 256;
    private static final String TAG_MEMORY = "memory";
    private static final String TAG_ADDRESS = "address";
    private static final String TAG_STATE = "state";
    private static final byte DATA_TYPE_CLEAR = 0;
    private static final byte PACKET_CLEAR = 0;
    private static final byte PACKET_SINGLE = 1;
    private static final byte PACKET_FULL = 2;
    private static final float QUADS_U0 = 0.15625f;
    private static final float QUADS_V0 = 0.15625f;
    private static final float QUADS_SIZE_U = 0.125f;
    private static final float QUADS_SIZE_V = 0.125f;
    private static final float QUADS_STEP_U = 0.1875f;
    private static final float QUADS_STEP_V = 0.1875f;

    public ModuleRandomAccessMemory(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.clearOnDisabled();
        this.address = 0;
        this.state = State.ADDRESS;
    }

    @Override
    public void onWriteComplete(Port port) {
        this.state = State.ADDRESS;
        this.cancelWrite();
    }

    @Override
    public boolean onActivate(EntityPlayer player, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_70694_bm();
        if (!Items.isModuleReadOnlyMemory(heldItem)) {
            return false;
        }
        boolean isReading = player.func_70093_af();
        if (!isReading && this.getCasing().isLocked()) {
            return false;
        }
        if (!this.getCasing().getCasingWorld().field_72995_K) {
            if (isReading) {
                ItemModuleReadOnlyMemory.saveToStack(heldItem, this.memory);
            } else {
                this.load(ItemModuleReadOnlyMemory.loadFromStack(heldItem));
                this.sendFull();
            }
        }
        return true;
    }

    @Override
    public void onData(ByteBuf data) {
        switch (data.readByte()) {
            case 0: {
                this.clear();
                break;
            }
            case 1: {
                this.address = data.readByte();
                this.set(data.readByte());
                break;
            }
            case 2: {
                data.readBytes(this.memory);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled || !this.isVisible()) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        int cells = 4;
        int cellSize = 16;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int offset = (y * 4 + x) * 16;
                float brightness = 0.25f + this.sectorSum(offset, 16) * 0.75f;
                this.setCellColor(brightness);
                float u0 = 0.15625f + (float)x * 0.1875f;
                float v0 = 0.15625f + (float)y * 0.1875f;
                RenderUtil.drawUntexturedQuad(u0, v0, 0.125f, 0.125f);
            }
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.load(nbt.func_74770_j(TAG_MEMORY));
        this.address = nbt.func_74771_c(TAG_ADDRESS);
        this.state = EnumUtils.readFromNBT(State.class, TAG_STATE, nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74773_a(TAG_MEMORY, (byte[])this.memory.clone());
        nbt.func_74774_a(TAG_ADDRESS, this.address);
        EnumUtils.writeToNBT(this.state, TAG_STATE, nbt);
    }

    protected void clearOnDisabled() {
        this.clear();
        this.sendClear();
    }

    protected void beginRead(Pipe pipe) {
        pipe.beginRead();
    }

    @SideOnly(value=Side.CLIENT)
    protected void setCellColor(float brightness) {
        GL11.glColor4f((float)0.4f, (float)1.0f, (float)1.0f, (float)brightness);
    }

    private int get() {
        return this.memory[this.address & 0xFF] & 0xFF;
    }

    private void set(int value) {
        this.memory[this.address & 0xFF] = (byte)value;
    }

    private void clear() {
        Arrays.fill(this.memory, (byte)0);
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                this.beginRead(receivingPipe);
            }
            if (!receivingPipe.canTransfer()) continue;
            this.process(receivingPipe.read());
        }
    }

    private void process(short value) {
        switch (this.state) {
            case ADDRESS: {
                this.beginReadWrite((byte)value);
                break;
            }
            case ACCESS: {
                this.finishReading((byte)value);
            }
        }
    }

    private void beginReadWrite(byte address) {
        this.address = address;
        this.state = State.ACCESS;
        short value = (short)this.get();
        for (Port port : Port.VALUES) {
            this.getCasing().getSendingPipe(this.getFace(), port).beginWrite(value);
        }
    }

    private void finishReading(byte value) {
        this.set(value);
        this.state = State.ADDRESS;
        this.cancelWrite();
        this.sendSingle();
    }

    private void sendClear() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(0);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendSingle() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(1);
        data.writeByte((int)this.address);
        data.writeByte((int)this.memory[this.address & 0xFF]);
        this.getCasing().sendData(this.getFace(), data);
    }

    private void sendFull() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(2);
        data.writeBytes(this.memory);
        this.getCasing().sendData(this.getFace(), data);
    }

    private float sectorSum(int offset, int count) {
        int sum = 0;
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            sum += this.memory[i] & 0xFF;
        }
        return (float)sum / ((float)count * 255.0f);
    }

    protected final void load(byte[] data) {
        System.arraycopy(data, 0, this.memory, 0, Math.min(data.length, this.memory.length));
        if (data.length < this.memory.length) {
            Arrays.fill(this.memory, data.length, this.memory.length, (byte)0);
        }
    }

    protected static enum State {
        ADDRESS,
        ACCESS;

    }
}

