/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.util.OneEightCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public final class ModuleSequencer
extends AbstractModuleRotatable {
    private final boolean[][] configuration = new boolean[8][8];
    private int position = -1;
    private int delay = 4;
    private int stepsRemaining = 0;
    private static final String TAG_CONFIGURATION = "configuration";
    private static final String TAG_POSITION = "position";
    private static final String TAG_DELAY = "delay";
    private static final String TAG_STEPS_REMAINING = "stepsRemaining";
    private static final byte DATA_TYPE_CONFIGURATION = 0;
    private static final byte DATA_TYPE_POSITION = 1;
    private static final int COL_COUNT = 8;
    private static final int ROW_COUNT = 8;
    private static final float CELLS_U0 = 0.15625f;
    private static final float CELLS_V0 = 0.15625f;
    private static final float CELLS_SIZE_U = 0.03125f;
    private static final float CELLS_SIZE_V = 0.03125f;
    private static final float CELLS_STEP_U = 0.09375f;
    private static final float CELLS_STEP_V = 0.09375f;
    private static final float CELLS_OUTER_U0 = 0.125f;
    private static final float CELLS_OUTER_V0 = 0.125f;
    private static final float CELLS_OUTER_SIZE_U = 0.09375f;
    private static final float CELLS_OUTER_SIZE_V = 0.09375f;
    private static final float CELLS_OUTER_STEP_U = 0.09375f;
    private static final float CELLS_OUTER_STEP_V = 0.09375f;
    private static final float BAR_U0 = 0.125f;
    private static final float BAR_V0 = 0.125f;
    private static final float BAR_SIZE_U = 0.09375f;
    private static final float BAR_SIZE_V = 0.75f;
    private static final float BAR_STEP_U = 0.09375f;
    private short output;

    public ModuleSequencer(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepInput();
        this.stepOutput();
    }

    @Override
    public void onEnabled() {
        super.onEnabled();
    }

    @Override
    public void onDisabled() {
        this.position = -1;
        this.stepsRemaining = 0;
    }

    @Override
    public boolean onActivate(EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        World world = this.getCasing().getCasingWorld();
        if (world.field_72995_K) {
            Vec3 uv = this.hitToUV(Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
            int col = this.uvToCol((float)uv.field_72450_a);
            int row = this.uvToRow((float)uv.field_72448_b);
            if (col >= 0 && row >= 0) {
                this.configuration[col][row] = !this.configuration[col][row];
                this.sendConfiguration(Side.SERVER);
            }
        }
        return true;
    }

    @Override
    public void onData(ByteBuf data) {
        if (this.getCasing().getCasingWorld().field_72995_K) {
            if (data.readBoolean()) {
                ModuleSequencer.decodeConfiguration(data.readLong(), this.configuration);
            } else {
                this.position = data.readByte();
            }
        } else {
            ModuleSequencer.decodeConfiguration(data.readLong(), this.configuration);
            this.sendConfiguration(Side.CLIENT);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        Vec3 hitPos;
        if (!this.isVisible()) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        if (enabled) {
            float barU0 = 0.125f + 0.09375f * (float)this.position;
            float brightness = 0.75f + 0.25f * (this.delay == 0 ? 1.0f : 1.0f - (float)(this.delay - this.stepsRemaining) / (float)this.delay);
            GL11.glColor4f((float)0.2f, (float)0.3f, (float)0.35f, (float)brightness);
            RenderUtil.drawUntexturedQuad(barU0, 0.125f, 0.09375f, 0.75f);
        }
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(enabled ? 1.0f : 0.5f));
        RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_SEQUENCER));
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)true);
        if (OneEightCompat.getDistanceSqToCenter((Entity)Minecraft.func_71410_x().field_71439_g, this.getCasing().getPositionX(), this.getCasing().getPositionY(), this.getCasing().getPositionZ()) < 64.0) {
            GL11.glColor4f((float)0.8f, (float)0.85f, (float)0.875f, (float)(enabled ? 1.0f : 0.5f));
            for (int col = 0; col < 8; ++col) {
                for (int row = 0; row < 8; ++row) {
                    if (!this.configuration[col][row]) continue;
                    float u0 = 0.15625f + 0.09375f * (float)col;
                    float v0 = 0.15625f + 0.09375f * (float)row;
                    RenderUtil.drawUntexturedQuad(u0, v0, 0.03125f, 0.03125f);
                }
            }
        }
        if ((hitPos = this.getPlayerLookAt()) != null) {
            Vec3 uv = this.hitToUV(hitPos);
            int col = this.uvToCol((float)uv.field_72450_a);
            int row = this.uvToRow((float)uv.field_72448_b);
            if (col >= 0 && row >= 0) {
                GL11.glColor4f((float)0.7f, (float)0.8f, (float)0.9f, (float)0.5f);
                float u = 0.125f + (float)col * 0.09375f;
                float v = 0.125f + (float)row * 0.09375f;
                RenderUtil.drawUntexturedQuad(u, v, 0.09375f, 0.09375f);
            }
        }
        GL11.glDisable((int)3042);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        ModuleSequencer.decodeConfiguration(nbt.func_74763_f(TAG_CONFIGURATION), this.configuration);
        this.position = Math.min(Math.max(nbt.func_74762_e(TAG_POSITION), 0), 7);
        this.delay = Math.min(Math.max(nbt.func_74762_e(TAG_DELAY), 0), 65535);
        this.stepsRemaining = Math.min(Math.max(nbt.func_74762_e(TAG_STEPS_REMAINING), 0), 65535);
        this.initializeOutput();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74772_a(TAG_CONFIGURATION, ModuleSequencer.encodeConfiguration(this.configuration));
        nbt.func_74768_a(TAG_POSITION, this.position);
        nbt.func_74768_a(TAG_DELAY, this.delay);
        nbt.func_74768_a(TAG_STEPS_REMAINING, this.stepsRemaining);
    }

    private void stepOutput() {
        if (this.stepsRemaining-- <= 0) {
            this.stepsRemaining = this.delay;
            this.cancelWrite();
            this.position = (this.position + 1) % 8;
            this.sendPosition();
            this.initializeOutput();
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.output);
            }
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.delay = receivingPipe.read() & 0xFFFF;
        }
    }

    private void sendConfiguration(Side toSide) {
        ByteBuf data = Unpooled.buffer();
        if (toSide == Side.CLIENT) {
            data.writeBoolean(true);
        }
        data.writeLong(ModuleSequencer.encodeConfiguration(this.configuration));
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendPosition() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(false);
        data.writeByte(this.position);
        this.getCasing().sendData(this.getFace(), data, (byte)1);
    }

    private void initializeOutput() {
        this.output = 0;
        int mask = 1;
        int row = 0;
        while (row < 8) {
            if (this.configuration[this.position][row]) {
                this.output = (short)(this.output | mask);
            }
            ++row;
            mask <<= 1;
        }
    }

    private static long encodeConfiguration(boolean[][] configuration) {
        long encodedConfiguration = 0L;
        long mask = 1L;
        for (int col = 0; col < 8; ++col) {
            int row = 0;
            while (row < 8) {
                if (configuration[col][row]) {
                    encodedConfiguration |= mask;
                }
                ++row;
                mask <<= 1;
            }
        }
        return encodedConfiguration;
    }

    private static void decodeConfiguration(long encodedConfiguration, boolean[][] configuration) {
        long mask = 1L;
        for (int col = 0; col < 8; ++col) {
            int row = 0;
            while (row < 8) {
                configuration[col][row] = (encodedConfiguration & mask) != 0L;
                ++row;
                mask <<= 1;
            }
        }
    }

    private int uvToCol(float u) {
        if (u < 0.125f || u > 0.875f) {
            return -1;
        }
        float mappedU = (u - 0.125f) / 0.75f;
        return (int)(mappedU * 8.0f);
    }

    private int uvToRow(float v) {
        if (v < 0.125f || v > 0.875f) {
            return -1;
        }
        float mappedV = (v - 0.125f) / 0.75f;
        return (int)(mappedV * 8.0f);
    }
}

