/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.LinkedList;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.gui.GuiModuleTerminal;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.client.renderer.font.FontRenderer;
import li.cil.tis3d.client.renderer.font.FontRendererNormal;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.gui.GuiHandlerCommon;
import li.cil.tis3d.util.OneEightCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public final class ModuleTerminal
extends AbstractModuleRotatable {
    private final LinkedList<StringBuilder> display = new LinkedList();
    private final StringBuilder output = new StringBuilder();
    private final StringBuilder input = new StringBuilder();
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_OUTPUT = "output";
    private static final byte DATA_TYPE_INPUT = 0;
    private static final byte PACKET_INPUT = 0;
    private static final byte PACKET_DISPLAY = 1;
    private static final byte PACKET_CLEAR = 2;
    private static final int MAX_ROWS = 21;
    private static final int MAX_COLUMNS = 40;
    private static final int TAB_WIDTH = 2;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Charset CP437 = Charset.forName("Cp437");
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(1);
    private final CharBuffer charBuffer = CharBuffer.allocate(1);
    private final CharsetDecoder decoder = CP437.newDecoder();
    private final CharsetEncoder encoder = CP437.newEncoder();
    private ByteBuf sendBuffer;
    private long lastSendTick = 0L;
    private boolean isInputEnabled;

    public ModuleTerminal(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        boolean isWriting = this.isWriting();
        for (Port port : Port.VALUES) {
            this.stepInput(port);
            if (!isWriting) continue;
            this.stepOutput(port);
        }
        World world = this.getCasing().getCasingWorld();
        if (this.sendBuffer != null && world.func_82737_E() > this.lastSendTick) {
            this.getCasing().sendData(this.getFace(), this.sendBuffer);
            this.sendBuffer = null;
        }
        this.lastSendTick = world.func_82737_E();
    }

    @Override
    public void onDisabled() {
        this.display.clear();
        this.output.setLength(0);
        ByteBuf data = Unpooled.buffer();
        data.writeByte(2);
        this.getCasing().sendData(this.getFace(), data);
    }

    @Override
    public void onDisposed() {
        if (this.getCasing().getCasingWorld().field_72995_K) {
            this.closeGui();
        }
    }

    @Override
    public void onWriteComplete(Port port) {
        this.output.setLength(this.output.length() - 1);
        this.cancelWrite();
        if (!this.isWriting()) {
            this.sendInputEnabled(true);
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.getCasing().isEnabled()) {
            return true;
        }
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            player.openGui((Object)TIS3D.instance, GuiHandlerCommon.GuiId.MODULE_TERMINAL.ordinal(), world, 0, 0, 0);
        }
        return true;
    }

    @Override
    public void onData(ByteBuf data) {
        if (this.getCasing().getCasingWorld().field_72995_K) {
            switch (data.readByte()) {
                case 0: {
                    this.isInputEnabled = data.readBoolean();
                    if (this.isInputEnabled) break;
                    this.input.setLength(0);
                    break;
                }
                case 1: {
                    while (data.isReadable()) {
                        this.writeToDisplay(data.readChar());
                    }
                    break;
                }
                case 2: {
                    this.display.clear();
                    this.output.setLength(0);
                    this.input.setLength(0);
                    this.isInputEnabled = true;
                }
            }
        } else if (!this.isWriting()) {
            this.beginWriting(ModuleTerminal.readString(data));
            this.sendInputEnabled(false);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled || !this.isVisible()) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        GL11.glEnable((int)3042);
        if (OneEightCompat.getDistanceSqToCenter((Entity)Minecraft.func_71410_x().field_71439_g, this.getCasing().getPositionX(), this.getCasing().getPositionY(), this.getCasing().getPositionZ()) < 64.0) {
            this.renderText();
        } else {
            RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_TERMINAL));
        }
        GL11.glDisable((int)3042);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList lines = nbt.func_150295_c(TAG_DISPLAY, 8);
        this.display.clear();
        for (int tagIndex = 0; tagIndex < lines.func_74745_c(); ++tagIndex) {
            this.display.add(new StringBuilder(lines.func_150307_f(tagIndex)));
        }
        this.output.setLength(0);
        this.output.append(nbt.func_74779_i(TAG_OUTPUT));
        this.isInputEnabled = this.output.length() == 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList lines = new NBTTagList();
        for (StringBuilder line : this.display) {
            lines.func_74742_a((NBTBase)new NBTTagString(line.toString()));
        }
        nbt.func_74782_a(TAG_DISPLAY, (NBTBase)lines);
        nbt.func_74778_a(TAG_OUTPUT, this.output.toString());
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            char ch = this.toChar(receivingPipe.read());
            this.writeToDisplay(ch);
            this.sendDisplayToClient(ch);
        }
    }

    private void stepOutput(Port port) {
        Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
        if (!sendingPipe.isWriting()) {
            sendingPipe.beginWrite(this.toShort(this.peekChar()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderText() {
        GL11.glTranslatef((float)0.125f, (float)0.125f, (float)0.0f);
        GL11.glScalef((float)0.001953125f, (float)0.001953125f, (float)1.0f);
        FontRenderer fontRenderer = FontRendererNormal.INSTANCE;
        int totalWidth = 384;
        int textWidth = 40 * fontRenderer.getCharWidth();
        float offsetX = (float)(384 - textWidth) / 2.0f;
        GL11.glTranslatef((float)offsetX, (float)10.0f, (float)0.0f);
        this.renderDisplay(fontRenderer);
        GL11.glTranslatef((float)0.0f, (float)((21 - this.display.size()) * fontRenderer.getCharHeight() + 4), (float)0.0f);
        this.renderInput(fontRenderer, textWidth);
    }

    private void renderDisplay(FontRenderer fontRenderer) {
        for (StringBuilder line : this.display) {
            fontRenderer.drawString(line);
            GL11.glTranslatef((float)0.0f, (float)fontRenderer.getCharHeight(), (float)0.0f);
        }
    }

    private void renderInput(FontRenderer fontRenderer, int textWidth) {
        if (!this.isInputEnabled) {
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        RenderUtil.drawUntexturedQuad(-4.0f, 0.0f, textWidth + 8, 24.0f);
        GL11.glColor4f((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
        RenderUtil.drawUntexturedQuad(-2.0f, 2.0f, textWidth + 4, 20.0f);
        if (!this.isInputEnabled) {
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glEnable((int)3553);
        GL11.glTranslatef((float)0.0f, (float)4.0f, (float)0.0f);
        fontRenderer.drawString(this.input);
        if (this.isInputEnabled && this.input.length() < 40 && System.currentTimeMillis() % 800L > 400L) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3553);
            RenderUtil.drawUntexturedQuad(this.input.length() * fontRenderer.getCharWidth(), 0.0f, fontRenderer.getCharWidth(), fontRenderer.getCharHeight());
            GL11.glEnable((int)3553);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void closeGui() {
        GuiModuleTerminal gui;
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiModuleTerminal && (gui = (GuiModuleTerminal)screen).isFor(this)) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    private void sendInputEnabled(boolean value) {
        ByteBuf response = Unpooled.buffer();
        response.writeByte(0);
        response.writeBoolean(value);
        this.getCasing().sendData(this.getFace(), response, (byte)0);
    }

    private void sendDisplayToClient(char ch) {
        if (this.sendBuffer == null) {
            this.sendBuffer = Unpooled.buffer();
            this.sendBuffer.writeByte(1);
        }
        this.sendBuffer.writeChar((int)ch);
    }

    private void sendInputToServer() {
        ByteBuf data = Unpooled.buffer();
        ModuleTerminal.writeString(data, this.input.toString());
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private static void writeString(ByteBuf data, String value) {
        byte[] bytes = value.getBytes(UTF_8);
        int byteCount = Math.min(255, bytes.length);
        data.writeByte((int)((byte)byteCount));
        data.writeBytes(bytes, 0, byteCount);
    }

    private static String readString(ByteBuf data) {
        int byteCount = data.readByte() & 0xFF;
        byte[] bytes = new byte[byteCount];
        data.readBytes(bytes);
        return new String(bytes, UTF_8);
    }

    private char toChar(short value) {
        this.byteBuffer.clear();
        this.charBuffer.clear();
        this.decoder.reset();
        this.byteBuffer.put((byte)value);
        this.byteBuffer.rewind();
        this.decoder.decode(this.byteBuffer, this.charBuffer, true);
        this.charBuffer.rewind();
        if (this.charBuffer.hasRemaining()) {
            return this.charBuffer.get();
        }
        return '\u0000';
    }

    private short toShort(char ch) {
        this.byteBuffer.clear();
        this.charBuffer.clear();
        this.encoder.reset();
        this.charBuffer.put(ch);
        this.charBuffer.rewind();
        this.encoder.encode(this.charBuffer, this.byteBuffer, true);
        this.byteBuffer.rewind();
        if (this.byteBuffer.hasRemaining()) {
            return (short)(this.byteBuffer.get() & 0xFF);
        }
        return 0;
    }

    private void writeToDisplay(char ch) {
        if (this.display.isEmpty()) {
            this.display.add(new StringBuilder());
        }
        if (ch == '\u0007') {
            this.bell();
        } else if (ch == '\b') {
            ModuleTerminal.backspace(this.display.getLast());
        } else if (ch == '\t') {
            this.wrapIfNecessary();
            ModuleTerminal.tab(this.display.getLast());
        } else if (ch == '\n' || ch == '\r') {
            this.newLine();
        } else {
            this.wrapIfNecessary();
            ModuleTerminal.character(this.display.getLast(), ch);
        }
    }

    public void writeToInput(char ch) {
        if (ch == '\b') {
            ModuleTerminal.backspace(this.input);
        } else if (ch == '\t') {
            ModuleTerminal.tab(this.input);
        } else if (ch == '\n' || ch == '\r') {
            this.sendInputToServer();
        } else if (this.toShort(ch) != 0) {
            ModuleTerminal.character(this.input, this.toChar(this.toShort(ch)));
        }
    }

    private void bell() {
        World world = this.getCasing().getCasingWorld();
        if (!world.field_72995_K) {
            world.func_72908_a((double)this.getCasing().getPositionX(), (double)this.getCasing().getPositionY(), (double)this.getCasing().getPositionZ(), "note.pling", 0.3f, 0.2f);
        }
    }

    private static void backspace(StringBuilder line) {
        if (line.length() > 0) {
            line.setLength(line.length() - 1);
        }
    }

    private static void tab(StringBuilder line) {
        if (line.length() < 40) {
            do {
                line.append(' ');
            } while (line.length() % 2 != 0 && line.length() < 40);
        }
    }

    private static void character(StringBuilder line, char ch) {
        if (line.length() < 40) {
            line.append(ch);
        }
    }

    private void wrapIfNecessary() {
        if (this.display.getLast().length() >= 40) {
            this.newLine();
        }
    }

    private void newLine() {
        StringBuilder line = null;
        while (this.display.size() >= 21) {
            line = this.display.removeFirst();
        }
        if (line == null) {
            line = new StringBuilder();
        } else {
            line.setLength(0);
        }
        this.display.addLast(line);
    }

    private boolean isWriting() {
        return this.output.length() > 0;
    }

    private void beginWriting(String value) {
        this.stopWriting();
        this.output.append(value);
        this.output.append('\u0000');
        this.output.reverse();
    }

    private char peekChar() {
        return this.output.charAt(this.output.length() - 1);
    }

    private void stopWriting() {
        this.output.setLength(0);
    }
}

