/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleRotatable;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.renderer.TextureLoader;
import li.cil.tis3d.client.renderer.font.FontRenderer;
import li.cil.tis3d.client.renderer.font.FontRendererNormal;
import li.cil.tis3d.util.OneEightCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public final class ModuleTimer
extends AbstractModuleRotatable {
    private long timer;
    private static final String TAG_TIMER = "timer";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final short OUTPUT_VALUE = 1;
    private boolean hasElapsed;

    public ModuleTimer(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        long worldTime;
        if (!this.hasElapsed && (worldTime = this.getCasing().getCasingWorld().func_82737_E()) >= this.timer) {
            this.hasElapsed = true;
        }
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.timer = 0L;
        this.hasElapsed = true;
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.timer = data.readLong();
        this.hasElapsed = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        this.rotateForRendering();
        RenderUtil.ignoreLighting();
        RenderUtil.drawQuad(RenderUtil.getSprite(TextureLoader.LOCATION_OVERLAY_MODULE_TIMER));
        if (!this.hasElapsed && OneEightCompat.getDistanceSqToCenter((Entity)Minecraft.func_71410_x().field_71439_g, this.getCasing().getPositionX(), this.getCasing().getPositionY(), this.getCasing().getPositionZ()) < 64.0) {
            long worldTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            float remaining = (float)(this.timer - worldTime) - partialTicks;
            if (remaining <= 0.0f) {
                this.hasElapsed = true;
            } else {
                this.drawState(remaining);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.timer = nbt.func_74763_f(TAG_TIMER);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74772_a(TAG_TIMER, this.timer);
    }

    private void setTimer(short value) {
        long worldTime = this.getCasing().getCasingWorld().func_82737_E();
        this.timer = worldTime + (long)(value & 0xFFFF);
        boolean bl = this.hasElapsed = this.timer == worldTime;
        if (!this.hasElapsed) {
            this.cancelWrite();
        }
        this.sendData();
    }

    private void stepOutput() {
        if (!this.hasElapsed) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite((short)1);
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.setTimer(receivingPipe.read());
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeLong(this.timer);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawState(float remaining) {
        float milliseconds = remaining * 50.0f;
        float seconds = milliseconds / 1000.0f;
        int minutes = (int)(seconds / 60.0f);
        String time = minutes > 0 ? String.format("%d:%02d", minutes, (int)seconds % 60) : String.format("%.2f", Float.valueOf(seconds));
        FontRenderer fontRenderer = FontRendererNormal.INSTANCE;
        int width = time.length() * fontRenderer.getCharWidth();
        int height = fontRenderer.getCharHeight();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glScalef((float)0.0125f, (float)0.0125f, (float)1.0f);
        GL11.glTranslatef((float)((float)(-width) / 2.0f + 1.0f), (float)((float)(-height) / 2.0f + 1.0f), (float)0.0f);
        fontRenderer.drawString(time);
    }
}

