/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.handler;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public abstract class AbstractMessageHandler<T extends IMessage>
implements IMessageHandler<T, IMessage> {
    public IMessage onMessage(T message, MessageContext context) {
        this.onMessageSynchronized(message, context);
        return null;
    }

    protected abstract void onMessageSynchronized(T var1, MessageContext var2);

    protected World getWorld(int dimension, MessageContext context) {
        switch (context.side) {
            case CLIENT: {
                return AbstractMessageHandler.getWorldClient(dimension);
            }
            case SERVER: {
                return AbstractMessageHandler.getWorldServer(dimension);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static World getWorldClient(int dimension) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        if (world == null) {
            return null;
        }
        if (world.field_73011_w.field_76574_g != dimension) {
            return null;
        }
        return world;
    }

    private static World getWorldServer(int dimension) {
        return DimensionManager.getWorld((int)dimension);
    }
}

