/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.network.message.AbstractMessageWithLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public final class MessageCasingInventory
extends AbstractMessageWithLocation {
    private int slot;
    private ItemStack stack;
    private NBTTagCompound moduleData;

    public MessageCasingInventory(Casing casing, int slot, ItemStack stack, @Nullable NBTTagCompound moduleData) {
        super(casing.getCasingWorld(), casing.getPositionX(), casing.getPositionY(), casing.getPositionZ());
        this.slot = slot;
        this.stack = stack;
        this.moduleData = moduleData;
    }

    public MessageCasingInventory() {
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public NBTTagCompound getModuleData() {
        return this.moduleData != null ? this.moduleData : new NBTTagCompound();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        PacketBuffer packet = new PacketBuffer(buf);
        this.slot = packet.readByte() & 0xFF;
        try {
            this.stack = packet.func_150791_c();
        }
        catch (IOException e) {
            TIS3D.getLog().warn("Failed parsing received ItemStack.", (Throwable)e);
            this.stack = null;
        }
        try {
            this.moduleData = packet.func_150793_b();
        }
        catch (IOException e) {
            TIS3D.getLog().warn("Failed parsing received NBTTagCompound.", (Throwable)e);
            this.moduleData = new NBTTagCompound();
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        PacketBuffer packet = new PacketBuffer(buf);
        try {
            packet.writeByte(this.slot);
            packet.func_150788_a(this.stack);
            packet.func_150786_a(this.moduleData);
        }
        catch (IOException e) {
            TIS3D.getLog().warn("Failed sending packet.", (Throwable)e);
        }
    }
}

