/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import li.cil.tis3d.common.TIS3D;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public final class MessageParticleEffect
implements IMessage {
    private int dimension;
    private String particleType;
    private double x;
    private double y;
    private double z;

    public MessageParticleEffect(World world, String particleType, double x, double y, double z) {
        this.dimension = world.field_73011_w.field_76574_g;
        this.particleType = particleType;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public MessageParticleEffect() {
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getParticleType() {
        return this.particleType;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            this.dimension = buffer.readInt();
            this.particleType = buffer.func_150789_c(32);
            this.x = buffer.readDouble();
            this.y = buffer.readDouble();
            this.z = buffer.readDouble();
        }
        catch (IOException e) {
            TIS3D.getLog().warn("Invalid packet received.", (Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            buffer.writeInt(this.dimension);
            buffer.func_150785_a(this.particleType);
            buffer.writeDouble(this.x);
            buffer.writeDouble(this.y);
            buffer.writeDouble(this.z);
        }
        catch (IOException e) {
            TIS3D.getLog().warn("Failed sending packet.", (Throwable)e);
        }
    }
}

