/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.tileentity;

import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.machine.PipeHost;
import li.cil.tis3d.common.machine.PipeImpl;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

abstract class TileEntityComputer
extends TileEntity
implements PipeHost {
    private final PipeImpl[] pipes = new PipeImpl[Face.VALUES.length * Port.VALUES.length];
    private static final Face[][] FACE_MAPPING = new Face[][]{{Face.X_POS, Face.X_NEG, Face.Z_NEG, Face.Z_POS}, {Face.X_POS, Face.X_NEG, Face.Z_POS, Face.Z_NEG}, {Face.X_POS, Face.X_NEG, Face.Y_POS, Face.Y_NEG}, {Face.X_NEG, Face.X_POS, Face.Y_POS, Face.Y_NEG}, {Face.Z_NEG, Face.Z_POS, Face.Y_POS, Face.Y_NEG}, {Face.Z_POS, Face.Z_NEG, Face.Y_POS, Face.Y_NEG}};
    private static final Port[][] PORT_MAPPING = new Port[][]{{Port.DOWN, Port.DOWN, Port.DOWN, Port.DOWN}, {Port.UP, Port.UP, Port.UP, Port.UP}, {Port.RIGHT, Port.LEFT, Port.DOWN, Port.UP}, {Port.RIGHT, Port.LEFT, Port.UP, Port.DOWN}, {Port.RIGHT, Port.LEFT, Port.RIGHT, Port.RIGHT}, {Port.RIGHT, Port.LEFT, Port.LEFT, Port.LEFT}};
    private static final String TAG_PIPES = "pipes";
    private final TileEntityComputer[] neighbors = new TileEntityComputer[Face.VALUES.length];
    private final PipeImpl[] pipeOverride = new PipeImpl[this.pipes.length];

    TileEntityComputer() {
        for (Face face : Face.VALUES) {
            for (Port port : Port.VALUES) {
                int pipeIndex = TileEntityComputer.pack(face, port);
                this.pipeOverride[pipeIndex] = this.pipes[pipeIndex] = new PipeImpl(this, face, TileEntityComputer.mapFace(face, port), TileEntityComputer.mapPort(face, port));
            }
        }
    }

    void stepPipes() {
        for (PipeImpl pipe : this.pipes) {
            pipe.step();
        }
    }

    public Pipe[] getPipes() {
        return this.pipes;
    }

    public Pipe getReceivingPipe(Face face, Port port) {
        return this.pipeOverride[TileEntityComputer.pack(face, port)];
    }

    public Pipe getSendingPipe(Face face, Port port) {
        return this.pipeOverride[TileEntityComputer.packMapped(face, port)];
    }

    @Override
    public World getPipeHostWorld() {
        return this.func_145831_w();
    }

    @Override
    public int getPipeHostPositionX() {
        return this.field_145851_c;
    }

    @Override
    public int getPipeHostPositionY() {
        return this.field_145848_d;
    }

    @Override
    public int getPipeHostPositionZ() {
        return this.field_145849_e;
    }

    @Override
    public void onWriteComplete(Face sendingFace, Port sendingPort) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readFromNBTForServer(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeToNBTForServer(nbt);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        this.readFromNBTForClient(packet.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBTForClient(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void checkNeighbors() {
        for (EnumFacing facing : EnumFacing.values()) {
            int neighborX = this.field_145851_c + facing.func_82601_c();
            int neighborY = this.field_145848_d + facing.func_96559_d();
            int neighborZ = this.field_145849_e + facing.func_82599_e();
            if (this.func_145831_w().func_72899_e(neighborX, neighborY, neighborZ)) {
                TileEntity tileEntity = this.func_145831_w().func_147438_o(neighborX, neighborY, neighborZ);
                if (tileEntity instanceof TileEntityComputer) {
                    this.setNeighbor(Face.fromEnumFacing(facing), (TileEntityComputer)tileEntity);
                    continue;
                }
                this.setNeighbor(Face.fromEnumFacing(facing), null);
                continue;
            }
            this.setNeighbor(Face.fromEnumFacing(facing), null);
        }
    }

    protected abstract void scheduleScan();

    protected void setNeighbor(Face face, TileEntityComputer neighbor) {
        TileEntityComputer oldNeighbor = this.neighbors[face.ordinal()];
        if (neighbor != oldNeighbor) {
            this.neighbors[face.ordinal()] = neighbor;
            this.scheduleScan();
        }
    }

    protected void readFromNBTForServer(NBTTagCompound nbt) {
        NBTTagList pipesNbt = nbt.func_150295_c(TAG_PIPES, 10);
        int pipeCount = Math.min(pipesNbt.func_74745_c(), this.pipes.length);
        for (int i = 0; i < pipeCount; ++i) {
            this.pipes[i].readFromNBT(pipesNbt.func_150305_b(i));
        }
        this.readFromNBTCommon(nbt);
    }

    protected void writeToNBTForServer(NBTTagCompound nbt) {
        NBTTagList pipesNbt = new NBTTagList();
        for (PipeImpl pipe : this.pipes) {
            NBTTagCompound portNbt = new NBTTagCompound();
            pipe.writeToNBT(portNbt);
            pipesNbt.func_74742_a((NBTBase)portNbt);
        }
        nbt.func_74782_a(TAG_PIPES, (NBTBase)pipesNbt);
        this.writeToNBTCommon(nbt);
    }

    protected void readFromNBTForClient(NBTTagCompound nbt) {
        this.readFromNBTCommon(nbt);
    }

    protected void writeToNBTForClient(NBTTagCompound nbt) {
        this.writeToNBTCommon(nbt);
    }

    protected void readFromNBTCommon(NBTTagCompound nbt) {
    }

    protected void writeToNBTCommon(NBTTagCompound nbt) {
    }

    boolean hasNeighbor(Face face) {
        return this.neighbors[face.ordinal()] != null;
    }

    void rebuildOverrides() {
        System.arraycopy(this.pipes, 0, this.pipeOverride, 0, this.pipes.length);
        for (Face face : Face.VALUES) {
            if (this.neighbors[face.ordinal()] != null) continue;
            for (Port port : Port.VALUES) {
                Face otherFace = TileEntityComputer.mapFace(face, port);
                Port otherPort = TileEntityComputer.mapPort(face, port);
                TileEntityComputer neighbor = this.neighbors[otherFace.ordinal()];
                if (neighbor == null) continue;
                Face neighborFace = otherFace.getOpposite();
                Port neighborPort = TileEntityComputer.flipSide(otherFace, otherPort);
                neighbor.computePipeOverrides(neighborFace, neighborPort, this, face, port);
            }
        }
    }

    private static Face mapFace(Face face, Port port) {
        return FACE_MAPPING[face.ordinal()][port.ordinal()];
    }

    private static Port mapPort(Face face, Port port) {
        return PORT_MAPPING[face.ordinal()][port.ordinal()];
    }

    private static int pack(Face face, Port port) {
        return face.ordinal() * Port.VALUES.length + port.ordinal();
    }

    private static int packMapped(Face face, Port port) {
        return TileEntityComputer.mapFace(face, port).ordinal() * Port.VALUES.length + TileEntityComputer.mapPort(face, port).ordinal();
    }

    private static Port flipSide(Face face, Port port) {
        if (face == Face.Y_NEG || face == Face.Y_POS) {
            return port == Port.UP || port == Port.DOWN ? port.getOpposite() : port;
        }
        return port == Port.LEFT || port == Port.RIGHT ? port.getOpposite() : port;
    }

    private void computePipeOverrides(Face face, Port port, TileEntityComputer start, Face startFace, Port startPort) {
        if (start == this) {
            return;
        }
        Face otherFace = TileEntityComputer.mapFace(face, port);
        Port otherPort = TileEntityComputer.mapPort(face, port);
        TileEntityComputer neighbor = this.neighbors[otherFace.ordinal()];
        if (neighbor != null) {
            Face neighborFace = otherFace.getOpposite();
            Port neighborPort = TileEntityComputer.flipSide(otherFace, otherPort);
            neighbor.computePipeOverrides(neighborFace, neighborPort, start, startFace, startPort);
        } else {
            int receivingIndex = TileEntityComputer.pack(startFace, startPort);
            int mySendingIndex = TileEntityComputer.packMapped(otherFace, otherPort);
            start.pipeOverride[receivingIndex] = this.pipes[mySendingIndex];
        }
    }
}

