/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import li.cil.tis3d.api.machine.HaltAndCatchFireException;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.MessageHaltAndCatchFire;
import li.cil.tis3d.common.tileentity.TileEntityCasing;
import li.cil.tis3d.common.tileentity.TileEntityComputer;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public final class TileEntityController
extends TileEntityComputer {
    private static final int COOLDOWN_HCF = 60;
    private final List<TileEntityCasing> casings = new ArrayList<TileEntityCasing>(Settings.maxCasingsPerController);
    private ControllerState state = ControllerState.SCANNING;
    private ControllerState lastSentState = ControllerState.SCANNING;
    private static final String TAG_HCF_COOLDOWN = "hcfCooldown";
    private static final String TAG_STATE = "state";
    private boolean forceStep;
    private int hcfCooldown = 0;

    public ControllerState getState() {
        return this.state;
    }

    @Override
    public void scheduleScan() {
        this.state = ControllerState.SCANNING;
    }

    public void forceStep() {
        if (this.state == ControllerState.RUNNING) {
            this.forceStep = true;
            this.func_145831_w().func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.click", 0.2f, 0.8f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f);
        }
    }

    public void haltAndCatchFire() {
        if (!this.func_145831_w().field_72995_K) {
            this.state = ControllerState.READY;
            this.casings.forEach(TileEntityCasing::onDisabled);
            MessageHaltAndCatchFire message = new MessageHaltAndCatchFire(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            NetworkRegistry.TargetPoint target = Network.getTargetPoint(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, 32);
            Network.INSTANCE.getWrapper().sendToAllAround((IMessage)message, target);
        }
        this.hcfCooldown = 60;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.casings.forEach(TileEntityCasing::onDisabled);
        for (TileEntityCasing casing : this.casings) {
            casing.setController(null);
        }
        this.casings.clear();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (TileEntityCasing casing : this.casings) {
            casing.setController(null);
        }
    }

    @Override
    protected void readFromNBTForServer(NBTTagCompound nbt) {
        super.readFromNBTForServer(nbt);
        this.hcfCooldown = nbt.func_74762_e(TAG_HCF_COOLDOWN);
    }

    @Override
    protected void writeToNBTForServer(NBTTagCompound nbt) {
        super.writeToNBTForServer(nbt);
        nbt.func_74768_a(TAG_HCF_COOLDOWN, this.hcfCooldown);
    }

    @Override
    protected void readFromNBTForClient(NBTTagCompound nbt) {
        super.readFromNBTForClient(nbt);
        this.state = ControllerState.VALUES[nbt.func_74771_c(TAG_STATE) & 0xFF];
    }

    @Override
    protected void writeToNBTForClient(NBTTagCompound nbt) {
        super.writeToNBTForClient(nbt);
        nbt.func_74774_a(TAG_STATE, (byte)this.state.ordinal());
    }

    public void func_145845_h() {
        World world = this.func_145831_w();
        if (world.field_72995_K) {
            if (this.hcfCooldown > 0) {
                --this.hcfCooldown;
                for (EnumFacing facing : EnumFacing.values()) {
                    int neighborZ;
                    int neighborY;
                    int neighborX = this.field_145851_c + facing.func_82601_c();
                    if (world.func_147439_a(neighborX, neighborY = this.field_145848_d + facing.func_96559_d(), neighborZ = this.field_145849_e + facing.func_82599_e()).func_149662_c() || world.field_73012_v.nextFloat() > 0.25f) continue;
                    float ox = (float)neighborX + world.field_73012_v.nextFloat();
                    float oy = (float)neighborY + world.field_73012_v.nextFloat();
                    float oz = (float)neighborZ + world.field_73012_v.nextFloat();
                    world.func_72869_a("flame", (double)ox, (double)oy, (double)oz, 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (this.state != this.lastSentState) {
            Chunk chunk = world.func_72938_d(this.field_145851_c, this.field_145849_e);
            Block block = world.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            world.markAndNotifyBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e, chunk, block, block, 7);
            this.lastSentState = this.state;
        }
        if (this.hcfCooldown > 0) {
            --this.hcfCooldown;
            return;
        }
        if (this.state == ControllerState.SCANNING) {
            this.scan();
        }
        if (this.state != ControllerState.READY && this.state != ControllerState.RUNNING) {
            return;
        }
        int power = this.computePower();
        if (this.state == ControllerState.READY) {
            if (power < 1) {
                return;
            }
            this.state = ControllerState.RUNNING;
            this.casings.forEach(TileEntityCasing::onEnabled);
        }
        if (this.state == ControllerState.RUNNING) {
            boolean bl = this.forceStep = this.forceStep && power == 1;
            if (!world.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.state = ControllerState.READY;
                this.casings.forEach(TileEntityCasing::onDisabled);
            } else if (power > 1 || this.forceStep) {
                this.casings.forEach(TileEntityCasing::stepRedstone);
                try {
                    if (power < 15) {
                        int delay = 15 - power;
                        if (world.func_82737_E() % (long)delay == 0L || this.forceStep) {
                            this.step();
                        }
                    } else {
                        int steps = power / 15;
                        for (int step = 0; step < steps; ++step) {
                            this.step();
                        }
                    }
                }
                catch (HaltAndCatchFireException e) {
                    this.haltAndCatchFire();
                }
            }
            this.forceStep = false;
        }
    }

    static boolean addNeighbors(World world, TileEntity tileEntity, Set<TileEntity> processed, Queue<TileEntity> queue) {
        for (EnumFacing facing : EnumFacing.values()) {
            int neighborZ;
            int neighborY;
            int neighborX = tileEntity.field_145851_c + facing.func_82601_c();
            if (!world.func_72899_e(neighborX, neighborY = tileEntity.field_145848_d + facing.func_96559_d(), neighborZ = tileEntity.field_145849_e + facing.func_82599_e())) {
                return false;
            }
            TileEntity neighborTileEntity = world.func_147438_o(neighborX, neighborY, neighborZ);
            if (neighborTileEntity == null || !processed.add(neighborTileEntity) || !(neighborTileEntity instanceof TileEntityController) && !(neighborTileEntity instanceof TileEntityCasing)) continue;
            queue.add(neighborTileEntity);
        }
        return true;
    }

    private void scan() {
        HashSet<TileEntity> processed = new HashSet<TileEntity>();
        ArrayDeque<TileEntity> queue = new ArrayDeque<TileEntity>();
        ArrayList<TileEntityCasing> newCasings = new ArrayList<TileEntityCasing>(Settings.maxCasingsPerController);
        processed.add(this);
        queue.add(this);
        while (!queue.isEmpty()) {
            TileEntity tileEntity = (TileEntity)queue.remove();
            if (tileEntity instanceof TileEntityController) {
                if (tileEntity == this) {
                    if (TileEntityController.addNeighbors(this.func_145831_w(), tileEntity, processed, queue)) continue;
                    this.clear(ControllerState.INCOMPLETE);
                    return;
                }
                this.clear(ControllerState.MULTIPLE_CONTROLLERS);
                return;
            }
            if (newCasings.size() + 1 > Settings.maxCasingsPerController) {
                this.clear(ControllerState.TOO_COMPLEX);
                return;
            }
            TileEntityCasing casing = (TileEntityCasing)tileEntity;
            newCasings.add(casing);
            TileEntityController.addNeighbors(this.func_145831_w(), casing, processed, queue);
        }
        if (newCasings.stream().anyMatch(c -> c.func_145831_w() == null)) {
            return;
        }
        this.casings.removeAll(newCasings);
        this.casings.forEach(c -> c.setController(null));
        this.casings.forEach(TileEntityCasing::scheduleScan);
        this.casings.clear();
        this.casings.addAll(newCasings);
        this.casings.forEach(c -> c.setController(this));
        this.casings.forEach(TileEntityComputer::checkNeighbors);
        this.checkNeighbors();
        this.casings.forEach(TileEntityComputer::rebuildOverrides);
        this.rebuildOverrides();
        this.casings.sort(Comparator.comparing(t -> new ChunkCoordinates(t.field_145851_c, t.field_145848_d, t.field_145849_e)));
        this.state = ControllerState.READY;
    }

    private int computePower() {
        int acc = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            int inputX = this.field_145851_c + facing.func_82601_c();
            int inputY = this.field_145848_d + facing.func_96559_d();
            int inputZ = this.field_145849_e + facing.func_82599_e();
            acc += Math.max(0, Math.min(15, this.func_145831_w().func_72878_l(inputX, inputY, inputZ, facing.ordinal())));
        }
        return acc;
    }

    private void step() {
        this.casings.forEach(TileEntityCasing::stepModules);
        this.casings.forEach(TileEntityComputer::stepPipes);
        this.stepPipes();
    }

    private void clear(ControllerState toState) {
        for (TileEntityCasing casing : this.casings) {
            casing.setController(null);
        }
        if (toState != ControllerState.INCOMPLETE) {
            this.casings.forEach(TileEntityCasing::onDisabled);
        }
        this.casings.clear();
        this.state = toState;
    }

    public static enum ControllerState {
        SCANNING(false),
        MULTIPLE_CONTROLLERS(true),
        TOO_COMPLEX(true),
        INCOMPLETE(true),
        READY(false),
        RUNNING(false);

        public final boolean isError;
        public final String translateKey;
        public static final ControllerState[] VALUES;

        private ControllerState(boolean isError) {
            this.isError = isError;
            this.translateKey = "tis3d.controller.status." + this.name().toLowerCase(Locale.US);
        }

        static {
            VALUES = ControllerState.values();
        }
    }
}

